% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_chronograms.R
\docType{data}
\name{opentree_chronograms}
\alias{opentree_chronograms}
\title{Open Tree of Life Chronogram database in R}
\format{
A list of four elements, containing data from OpenTree of Life chronograms
\describe{
\item{authors}{A list of lists of author names of the original studies that
published chronograms in the Open Tree of Life database.}
\item{curators}{A list of lists of curator names that uploaded chronograms
to the Open Tree of Life database.}
\item{studies}{A list of study identifiers.}
\item{trees}{A \code{multiPhylo} object storing the chronograms from Open Tree of
Life database.}
\item{update}{A character vector indicating the time when the database object
was last updated.}
\item{version}{A character vector indicating when the chronogram database \code{opentree_chronograms}
object was last updated. Format is year.month.day}
}
}
\source{
\url{http://opentreeoflife.org}
}
\usage{
opentree_chronograms
}
\description{
Now storing >200 chronograms from Open Tree of Life
}
\details{
Generated with
\code{devtools::install_github("ropensci/rotl", ref = devtools::github_pull("137"))}
\code{remotes::install_github("ROpenSci/bibtex")}
opentree_chronograms <- get_opentree_chronograms()
opentree_chronograms$update_time <- Sys.time()
opentree_chronograms$version <- format(Sys.time(), "\%Y.\%m.\%d")
usethis::use_data(opentree_chronograms, overwrite = T, compress="xz")
and updated with update_datelife_cache()
}
\keyword{chronogram}
\keyword{dates}
\keyword{million}
\keyword{myrs}
\keyword{opentree}
\keyword{phylogeny}
\keyword{time}
\keyword{years}
