% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transition_info.R,
%   R/get_transition_info_utils.R
\name{get_transition_info}
\alias{get_transition_info}
\alias{validate_transition_info_input}
\alias{impute_trans}
\alias{recode_trans_names}
\title{Invoke the Transition Pairing Method}
\usage{
get_transition_info(predictions, references, window_size = 1, ...)

validate_transition_info_input(predictions, references)

impute_trans(x, out_length)

recode_trans_names(x)
}
\arguments{
\item{predictions}{A dummy-coded vector of predicted transitions (1)
interspersed with non-transitions (0). Logical vectors are coerced to
numeric.}

\item{references}{A dummy-coded vector of actual (i.e., reference)
transitions (1) interspersed with non-transitions (0). Logical vectors are
coerced to numeric.}

\item{window_size}{The maximum number of indices that are allowed to separate
a predicted and reference transition, before the two are considered
incompatible}

\item{...}{additional arguments passed to or from methods, not currently used}
}
\value{
an object of class \code{transition} that contains necessary
  information for evaluating the effectiveness of the predictions.
}
\description{
Invoke the Transition Pairing Method
}
\note{
If the lengths of \code{predictions} and \code{references} differ, a
  warning is issued, and the shorter vector will be expanded to match the
  length of the longer, using the original relative/proportional positions of
  the transitions to determine where they should be placed in the expanded
  vector. The relative position could be determined different ways, each
  having unique implications for how well aligned \code{predictions} and
  \code{references} are. Therefore, while this function is not unusable when
  the lengths differ, you should make sure you know what you're doing if you
  want to use it that way. The safest solution is to expand the shorter
  vector yourself.
}
\examples{
set.seed(100)
predictions <- (sample(1:100)\%\%2)
references  <- (sample(1:100)\%\%2)
window_size <- 7
if (isTRUE(requireNamespace("matchingMarkets", quietly = TRUE))) {
  get_transition_info(predictions, references, window_size)
}
}
\seealso{
\code{\link{summary.transition}}
}
\keyword{internal}
