% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianPCM.R
\name{PCMPExpxMeanExp}
\alias{PCMPExpxMeanExp}
\title{Create a function of time that calculates (1-exp(-lambda_{ij}*time))/lambda_{ij}
for every element lambda_{ij} of the input matrix Lambda_ij.}
\usage{
PCMPExpxMeanExp(Lambda_ij,
  threshold.Lambda_ij = getOption("PCMBase.Threshold.Lambda_ij", 1e-08))
}
\arguments{
\item{Lambda_ij}{a squared numerical matrix of dimension k x k}

\item{threshold.Lambda_ij}{a 0-threshold for abs(Lambda_i + Lambda_j), where Lambda_i
and Lambda_j are eigenvalues of the parameter matrix H. This
threshold-value is used as a condition to
take the limit time of the expression `(1-exp(-Lambda_ij*time))/Lambda_ij` as
`(Lambda_i+Lambda_j) --> 0`. You can control this value by the global option
"PCMBase.Threshold.Lambda_ij". The default value (1e-8) is suitable for branch
 lengths bigger than 1e-6. For smaller branch lengths, you may want to
 increase the threshold value using, e.g.
`options(PCMBase.Threshold.Lambda_ij=1e-6)`.}
}
\value{
a function of time returning a matrix with entries formed from the
 above function or the limit, time, if |Lambda_{ij}|<=trehshold0.
}
\description{
Create a function of time that calculates (1-exp(-lambda_{ij}*time))/lambda_{ij}
for every element lambda_{ij} of the input matrix Lambda_ij.
}
\details{
the function (1-exp(-lambda_{ij}*time))/lambda_{ij} corresponds to the product
of the CDF of an exponential distribution with rate Lambda_{ij} multiplied by its mean value (mean waiting time).
}
