% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_mpin.R
\name{initials_mpin}
\alias{initials_mpin}
\title{MPIN initial parameter sets of Ersan (2016)}
\usage{
initials_mpin(data, layers = NULL, detectlayers = "EG",
 xtraclusters = 4, verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{layers}{An integer referring to the assumed number of
information layers in the data. If the value of \code{layers} is \code{NULL}, then
the number of layers is automatically determined by one of the following
functions: \code{detectlayers_e()}, \code{detectlayers_eg()}, and \code{detectlayers_ecm()}.
The default value is \code{NULL}.}

\item{detectlayers}{A character string referring to the layer
detection algorithm used to determine the number of layers in the data. It
takes one of three values: \code{"E"}, \code{"EG"}, and \code{"ECM"}. \code{"E"} refers to the
algorithm in \insertCite{Ersan2016;textual}{PINstimation}, \code{"EG"} refers to
the algorithm in \insertCite{Ersan2022a;textual}{PINstimation}; while
\code{"ECM"} refers to the algorithm in
\insertCite{Ghachem2022;textual}{PINstimation}. The default value is \code{"EG"}.
Comparative results between the layer detection
algorithms can be found in \insertCite{Ersan2022a;textual}{PINstimation}.}

\item{xtraclusters}{An integer used to divide trading days into
\code{#(1 + layers + xtraclusters)} clusters, thereby resulting in
\code{#comb(layers + xtraclusters, layers)} initial parameter sets in
line with \insertCite{ErsanAlici2016;textual}{PINstimation}, and
\insertCite{Ersan2016;textual}{PINstimation}. The default value is \code{4}
as chosen in \insertCite{Ersan2016;textual}{PINstimation}.}

\item{verbose}{a binary variable that determines whether information messages
about the initial parameter sets, including the number of the initial
parameter sets generated. No message is shown when \code{verbose} is set
to \code{FALSE}. The default value is \code{TRUE}.}
}
\value{
Returns a dataframe of initial parameter sets each consisting of
\verb{3J + 2} variables \{\eqn{\alpha}, \eqn{\delta}, \eqn{\mu}, \eb, \es\}.
\eqn{\alpha}, \eqn{\delta}, and \eqn{\mu} are vectors of length \code{J} where
\code{J} is the number of layers in the \code{MPIN} model.
}
\description{
Based on the algorithm in
\insertCite{Ersan2016;textual}{PINstimation}, generates
initial parameter sets for the maximum likelihood estimation of the \code{MPIN}
model.
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# Obtain a dataframe of initial parameter sets for estimation of the MPIN
# model using the algorithm of Ersan (2016) with 3 extra clusters.
# By default, the number of layers in the data is detected using the
# algorithm of Ersan and Ghachem (2022a).

initparams <- initials_mpin(xdata, xtraclusters = 3, verbose = FALSE)

# Show the six first initial parameter sets

print(round(t(head(initparams)), 3))

# Use 10 randomly selected initial parameter sets from initparams to
# estimate the probability of informed trading via mpin_ecm. The number
# of information layers will be detected from the initial parameter sets.

numberofsets <- nrow(initparams)
selectedsets <- initparams[sample(numberofsets, 10),]
\donttest{
estimate <- mpin_ecm(xdata, initialsets = selectedsets, verbose = FALSE)

# Display the estimated MPIN value

show(estimate@mpin)

# Display the estimated parameters as a numeric vector.

show(unlist(estimate@parameters))

# Store the posterior probabilities in a variable, and show the first 6 rows.

modelposteriors <- get_posteriors(estimate)
show(round(head(modelposteriors), 3))
}
}
\references{
\insertAllCited
}
