% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetwork.R
\name{PLNnetwork}
\alias{PLNnetwork}
\title{Poisson lognormal model towards sparse network inference}
\usage{
PLNnetwork(
  formula,
  data,
  subset,
  weights,
  penalties = NULL,
  control = PLNnetwork_param()
)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which lm is called.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{an optional vector of observation weights to be used in the fitting process.}

\item{penalties}{an optional vector of positive real number controlling the level of sparsity of the underlying network. if NULL (the default), will be set internally. See \code{PLNnetwork_param()} for additional tuning of the penalty.}

\item{control}{a list-like structure for controlling the optimization, with default generated by \code{\link[=PLNnetwork_param]{PLNnetwork_param()}}. See the corresponding documentation for details;}
}
\value{
an R6 object with class \code{\link{PLNnetworkfamily}}, which contains
a collection of models with class \code{\link{PLNnetworkfit}}
}
\description{
Fit the sparse inverse covariance variant of the Poisson lognormal with a variational algorithm. Use the (g)lm syntax for model specification (covariates, offsets).
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
}
\seealso{
The classes \code{\link{PLNnetworkfamily}} and \code{\link{PLNnetworkfit}}, and the and the configuration function \code{\link[=PLNnetwork_param]{PLNnetwork_param()}}.
}
