% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{PLregcontrol}
\alias{PLregcontrol}
\alias{PLreg.control}
\title{Auxiliary for Controlling PL Fitting}
\usage{
PLreg.control(
  lambda = NULL,
  method = "BFGS",
  maxit = 2000,
  trace = FALSE,
  start = NULL,
  ...
)
}
\arguments{
\item{lambda}{numeric indicating the value of the skewness parameter lambda (if \code{NULL},
lambda will be estimated).}

\item{method}{character specifying the \code{method} argument passed to \code{\link{optim}}.}

\item{maxit, trace, ...}{arguments passed to \code{\link{optim}}}

\item{start}{an optional vector with starting values for median and dispersion submodels (starting value for lambda
must not be included).}
}
\value{
A list with components named as the arguments.
}
\description{
Parameters that control fitting of power logit regression models using \code{\link{PLreg}}.
}
\details{
The \code{PLreg.control} controls the fitting process of power logit models. Almost all the arguments
are passed on directly to \code{\link{optim}}, which is used to estimate the parameters.
Starting values for median and dispersion submodels may be supplied via \code{start}. If the
estimation process is to be performed with a fixed skewness parameter, a value must be specified
in \code{lambda}. If \code{lambda = 0}, a log-log regression model
will be estimated.
}
\examples{
data("PeruVotes")

fitPL <- PLreg(votes ~ HDI | HDI, data = PeruVotes,
              family = "TF", zeta = 5, control = PLreg.control(lambda = 1))
summary(fitPL)

}
\seealso{
\code{\link{PLreg}}
}
