% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerMCTests.R
\name{powerMCTests}
\alias{powerMCTests}
\title{Power Simulation for One-Factorial All-Pairs and Many-To-One Comparison Tests}
\usage{
powerMCTests(
  mu,
  n = 10,
  errfn = c("Normal", "Lognormal", "Exponential", "Chisquare", "TDist", "Cauchy",
    "Weibull"),
  parms = list(mean = 0, sd = 1),
  test = c("kwManyOneConoverTest", "kwManyOneDunnTest", "kwManyOneNdwTest",
    "vanWaerdenManyOneTest", "normalScoresManyOneTest", "dunnettTest",
    "tamhaneDunnettTest", "ManyOneUTest", "kwAllPairsNemenyiTest", "kwAllPairsDunnTest",
    "kwAllPairsConoverTest", "normalScoresAllPairsTest", "vanWaerdenAllPairsTest",
    "dscfAllPairsTest", "gamesHowellTest", "lsdTest", "scheffeTest", "tamhaneT2Test",
    "tukeyTest", "dunnettT3Test", "pairwise.t.test", "pairwise.wilcox.test",
    "adManyOneTest", "adAllPairsTest", "bwsManyOneTest",      "bwsAllPairsTest",
    "welchManyOneTTest"),
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods),
  alpha = 0.05,
  FWER = TRUE,
  replicates = 1000
)
}
\arguments{
\item{mu}{numeric vector of group means.}

\item{n}{number of replicates per group. If \code{n} is a scalar, then
a balanced design is assumed. Otherwise, \code{n} must be a vector of same
length as \code{mu}.}

\item{errfn}{the error function. Defaults to \code{"Normal"}.}

\item{parms}{a list that denotes the arguments for the error function.
Defaults to \code{list(mean=0, sd=1)}.}

\item{test}{the multiple comparison test for which the power analysis is
to be performed. Defaults to \code{"kwManyOneConoverTest"}.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"two.sided"},
ignored if the selected error function does not use this argument.}

\item{p.adjust.method}{method for adjusting p values (see \code{\link{p.adjust}}).}

\item{alpha}{the nominal level of Type I Error.}

\item{FWER}{logical, indicates whether the family-wise error should be computed.
Defaults to \code{TRUE}.}

\item{replicates}{the number of Monte Carlo replicates or runs. Defaults to \code{1000}.}
}
\value{
An object with class \code{powerPMCMR}.
}
\description{
Performs power simulation for one-factorial all-pairs and Many-To-One comparison tests.
}
\details{
The linear model of a one-way ANOVA can be written as:

\deqn{
X_{ij} = \mu_i + \epsilon_{ij}
}

For each Monte Carlo run, the function simulates \eqn{\epsilon_{ij}} based on the given error function and
the corresponding parameters. Then the specified all-pairs
or many-to-one comparison test is performed.
Finally, several effect sizes (Cohen's f ans R-squared),
error rates (per comparison error rate,
false discovery rate and familywise error rate)
and test powers (any-pair power, average per-pair power
and all-pairs power) are calculated.
}
\examples{
\dontrun{
mu <- c(0, 0, 1, 2)
n <- c(5, 4, 5, 5)
set.seed(100)
powerMCTests(mu, n, errfn="Normal",
 parms=list(mean=0, sd=1),
 test="dunnettTest", replicates=1E4)

powerMCTests(mu, n, errfn="Normal",
 parms=list(mean=0, sd=1),
 test="kwManyOneDunnTest", p.adjust.method = "bonferroni",
 replicates=1E4)

}

}
\concept{TestPower}
\keyword{misc}
