% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.std.err.R
\name{reg.std.err}
\alias{reg.std.err}
\title{Standard error for lim.fit}
\usage{
reg.std.err(SSE,dof)
}
\arguments{
\item{SSE}{:error sum of squared aka. residual sum of squared}

\item{dof}{:degree of freedom}
}
\description{
Calculate standard error for the outcome of lm.fit(). This function is built for reg.linreg for higher efficiency only.
It can't be used for calculating standard error in general operation.
}
\examples{
X <- as.matrix(cbind(1,EuStockMarkets[,1:2])) # create the design matrix
Y <- as.data.frame(EuStockMarkets)$FTSE
fit <- lm.fit(x = X, y = Y)
SSE <- sum((Y - fit$fitted.values)^2)
dof <- reg.dof(fit)
reg.std.err(SSE,dof)
}
