% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs_pssm.R
\name{CS_PSe_PSSM}
\alias{CS_PSe_PSSM}
\title{CSP-SegPseP-SegACP feature vector}
\usage{
CS_PSe_PSSM(pssm_name, vec_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}

\item{vec_name}{a character that user imports to specify kind of feature vector which it can be varied between
four values}
}
\value{
feature vector that its length depends on the vec_name which user imports
}
\description{
This feature vector is constructed  by fusing consensus sequence (CS), segmented PsePSSM, and
segmented auto-covariance transformation (ACT) based on PSSM. by consensus sequence a 40-dimensional feature
vector is obtained, in segmented PsePSSM group, by dividing PSSM Matrix to 2 and 3 segments a 380-dimensional
feature vector is obtained and in ACT group, similar to the previous group at first PSSM Matrix is divided
to 2 and 3 segments then a feature vector of length 280 is obtained.eventually by fusing these features a
700-dimensional feature vector is obtained.
}
\details{
If vec_name equals to "segmented_psepssm" then a feature vector of length 380 is obtained.
if vec_name equals to "segmented_acpssm" then a feature vector of length 280 is obtained, and if vec_name
equals to "cspssm" the obtained feature vector would be of length 40 eventually if vec_name equals to
"total" then feature vector would be of length 700.
}
\examples{
A<-CS_PSe_PSSM(system.file("extdata", "C7GSI6.txt.pssm", package="PSSMCOOL"),"total")
}
\references{
Y. Liang, S. Liu, S. J. C. Zhang, and m. m. i. medicine, "Prediction of protein structural
classes for low-similarity sequences based on consensus sequence and segmented PSSM," vol. 2015, 2015.
}
