% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pssm_sd.R
\name{pssm_seg}
\alias{pssm_seg}
\title{PSSM-Seg feature vector}
\usage{
pssm_seg(pssm_name, m = 4)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}

\item{m}{a parameter between 1 and 11}
}
\value{
feature vector of length 100
}
\description{
This feature vector uses PSSM-SD to produce Segmented Auto Covariance Features.
}
\examples{
q<-pssm_seg(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"),3)
}
\references{
A. Dehzangi, K. Paliwal, J. Lyons, A. Sharma, A. J. I. A. T. o. C. B. Sattar, and Bioinformatics,
"A segmentation-based method to extract structural and evolutionary features for protein fold
recognition," vol. 11, no. 3, pp. 510-519, 2014.
}
\seealso{
\code{\link{PSSM_SD}}
}
