% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooted_pssm.R
\name{smoothed_PSSM}
\alias{smoothed_PSSM}
\title{smoothed PSSM feature}
\usage{
smoothed_PSSM(pssm_name, ws, w, v = NULL)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}

\item{ws}{window size for smoothing PSSM Matrix}

\item{w}{window size for extracting feature vector}

\item{v}{vector of desired positions to extract their features}
}
\value{
a matrix of feature vectors
}
\description{
In this function at first a Matrix called smoothed-PSSM is constructed from PSSM Matrix
by applying "ws" parameter which called sliding window size and taken from user and usually is equals to 7. Then
using other window size parameter "w" which usually equals to 11 at each position smoothed feature vector is
constructed.
}
\details{
In the construction of a smoothed PSSM, each row vector of a residue \eqn{\alpha_i} is represented and
smoothed by the summation of ws surrounding row vectors \eqn{(V_{smoothed_i}=V_{i-(ws-1)/2}+...+V_i+...+
V_{i+(ws+1)/2})} For the N-terminal and C-terminal of a protein, (w-1)/2 ZERO vectors, are appended to the
head or tail of a smoothed PSSM profile. Using the smoothed PSSM encoding scheme the feature vector of a residue
\eqn{\alpha_i} is represented by \eqn{(V_{smoothed_i-(ws-1)/2},...,V_{smoothed_i},...,V_{smoothed_i+(ws+1)/2})}
The feature values in each vector are normalized to a range between -1 and 1.
}
\examples{
w<-smoothed_PSSM(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"),7,11,c(2,3,8,9))
}
\references{
Cheng, C.W., et al. (2008) Predicting RNA-binding sites of proteins using support vector machines and
evolutionary information, BMC Bioinformatics, 9 Suppl 12, S6.
}
\seealso{
\code{\link{kiderafactor}}
}
