% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_ContEVD}
\alias{plot_ContEVD}
\title{Plot contaminants from evidence.txt, broken down into top5-proteins.}
\usage{
plot_ContEVD(data, top5)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'contaminant', 'pname', 'intensity'}

\item{top5}{Name of the Top-5 Proteins (by relative intensity or whatever seems relevant)}
}
\value{
GGplot object
}
\description{
Plot contaminants from evidence.txt, broken down into top5-proteins.
}
\examples{

 data = data.frame(intensity = 1:12, 
                   pname = rep(letters[1:3], 4), 
                   fc.raw.file = rep(paste("f", 1:4), each=3),
                   contaminant = TRUE)
 ## providing more proteins than present... d,e will be ignored
 plot_ContEVD(data, top5 = letters[1:5])
 ## classify 'c' as 'other'
 plot_ContEVD(data, top5 = letters[1:2])

}

