% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSLangmuir3analysis.R
\name{SSLangmuir3analysis}
\alias{SSLangmuir3analysis}
\title{Langmuir Isotherm Nonlinear Analysis via selfStart and Langmuir Third Linear Model}
\usage{
SSLangmuir3analysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression via selfStart, initial starting values for parameters
based on Langmuir third linear model, predicted parameter values, and
model error analysis
}
\description{
The Langmuir isotherm is described to be the most useful and
simplest isotherm for both chemical adsorption and physical adsorption. It
assumes that there is uniform adsorption energy onto the monolayer surface
and that there would be no interaction between the adsorbate and the surface.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
SSLangmuir3analysis(Ce,Qe)
}
\references{
Langmuir, I. (1918) <doi:10.1021/ja01269a066> The adsorption of
gases on plane surfaces of glass, mics and platinum. Journal of the American
Chemical Society, 1361-1403.
}
\author{
Jemimah Christine L. Mesias

Chester C. Deocaris
}
