% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freundlichanalysis.R
\name{freundlichanalysis}
\alias{freundlichanalysis}
\title{Freundlich Isotherm Non-Linear Analysis}
\usage{
freundlichanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression, parameters for Freundlich isotherm,
and model error analysis
}
\description{
This isotherm model is an empirical model applicable to diluted
solutions adsorption processes. Furthermore, this model gives an equation which
defines the surface heterogeneity and the exponential distribution of active sites.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
freundlichanalysis(Ce,Qe)
}
\references{
Freundlich, H. 1907. Ueber die adsorption in loesungen. Z.
Phys. Chem.57:385-470

Foo, K. Y., and Hameed, B. H. (2009, September 13).
<doi:10.1016/j.cej.2009.09.013> Insights into the modeling of adsorption isotherm
systems. Chemical Engineering Journal.
}
\author{
Jemimah Christine L. Mesias

Chester C. Deocaris
}
