% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWindBarbs.R
\name{addWindBarbs}
\alias{addWindBarbs}
\title{Add wind barbs to a map}
\usage{
addWindBarbs(x, y, speed, dir, circleSize = 1,
  circleFill = "transparent", lineCol = 1, extraBarbLength = 0,
  barbSize = 1, ...)
}
\arguments{
\item{x}{vector of longitudes}

\item{y}{vector of latitudes}

\item{speed}{vector of wind speeds in knots}

\item{dir}{wind directions in degrees clockwise from north}

\item{circleSize}{size of the circle}

\item{circleFill}{circle fill color}

\item{lineCol}{line color (currently not supported)}

\item{extraBarbLength}{add length to barbs}

\item{barbSize}{size of the barb}

\item{...}{additional arguments to be passed to \code{lines}}
}
\description{
Add a multi-sided polygon to a plot.
}
\examples{
maps::map('state', "washington")
x <- c(-121, -122)
y <- c(47.676057, 47)
addWindBarbs(x, y, speed = c(45,65), dir = c(45, 67),
             circleSize = 1.8, circleFill = c('orange', 'blue'))
}
\references{
https://commons.wikimedia.org/wiki/Wind_speed
}
\keyword{plotting}
