% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDistribution.R
\name{getPredictionDistribution}
\alias{getPredictionDistribution}
\title{Calculates the prediction distribution}
\usage{
getPredictionDistribution(
  prediction,
  predictionType = "binary",
  typeColumn = "evaluation"
)
}
\arguments{
\item{prediction}{A prediction object}

\item{predictionType}{The type of prediction (binary or survival)}

\item{typeColumn}{A column that is used to stratify the results}
}
\value{
The 0.00, 0.1, 0.25, 0.5, 0.75, 0.9, 1.00 quantile pf the prediction,
the mean and standard deviation per class
}
\description{
Calculates the prediction distribution
}
\details{
Calculates the quantiles from a predition object
}
\examples{
prediction <- data.frame(rowId = 1:100, 
                         outcomeCount = stats::rbinom(1:100, 1, prob=0.5), 
                         value = runif(100), 
                         evaluation = rep("Train", 100))
getPredictionDistribution(prediction)
}
