% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAttributes.R
\name{addAttributes}
\alias{addAttributes}
\title{Get attributes from one cohort to another}
\usage{
addAttributes(newcohort, oldcohort)
}
\arguments{
\item{newcohort}{cohort to which to attach the attributes}

\item{oldcohort}{cohort from which to get the attributes}
}
\value{
new cohort with added attributes from the other given cohort
}
\description{
Get attributes from one cohort to another
}
\examples{
\donttest{
library(CDMConnector)
library(PatientProfiles)
library(dplyr)

cdm <- mockPatientProfiles()
attributes(cdm$cohort1)
x <- cdm$cohort1 \%>\%
  filter(cohort_definition_id == 1) \%>\%
  computeQuery()
attributes(x)
x <- addAttributes(x, cdm$cohort1)
attributes(cdm$cohort1)
}

}
