% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write.perseus}
\alias{write.perseus}
\alias{write.perseus.default}
\alias{write.perseus.matrixData}
\alias{write.perseus.list}
\alias{write.perseus.data.frame}
\alias{write.perseus.matrix}
\alias{write.perseus.ExpressionSet}
\title{write.perseus: function to generate a perseus-readable text document}
\usage{
write.perseus(object = NULL, con = NULL, ...)

\method{write.perseus}{default}(object = NULL, con = NULL, main,
  annotCols = NULL, annotRows = NULL, descr = NULL,
  imputeData = NULL, qualityData = NULL, ...)

\method{write.perseus}{matrixData}(object, con, ...)

\method{write.perseus}{list}(object, con, ...)

\method{write.perseus}{data.frame}(object, con, annotCols = NULL, ...)

\method{write.perseus}{matrix}(object, con, annotCols = NULL, ...)

\method{write.perseus}{ExpressionSet}(object, con, ...)
}
\arguments{
\item{object}{an expressionSet, matrixData, list or table-like object.}

\item{con}{A \code{\link{connection}} object or the path to output file}

\item{...}{additional arguments passed to other functions}

\item{main}{a data frame containing}

\item{annotCols}{a df containing columns containing metadata (about the rows)}

\item{annotRows}{a df containing columns containing metadata (about the columns)}

\item{descr}{a character vector that describes the columns in main and in annotCols (in that order)}

\item{imputeData}{a df containing imputations -- True or False of main data frame}

\item{qualityData}{a df containing quality values of main data frame}
}
\value{
writes to disk a perseus-interpretable text representation of an R object

\code{NULL}

\code{NULL}

\code{NULL}

\code{NULL}

\code{NULL}
}
\description{
Write data to a perseus text file or connection

Write Data to file in the custom Perseus matrix file format.
}
\examples{
df <- matrixData(
main=data.frame(a=1:3, b=6:8),
annotCols=data.frame(b=c('a','b','c')),
annotRows=data.frame(x=factor(c('1','1'))),
description=c('a','a','b'))
con <- textConnection('df1', 'w')
write.perseus(df, con)
close(con)
}
\seealso{
\code{\link{read.perseus}} \code{\link{matrixData}}
}
