% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_cap_hist.R
\name{split_cap_hist}
\alias{split_cap_hist}
\title{Split a vector of capture histories into a matrix with one column for each occasion}
\usage{
split_cap_hist(cap_hist, sep = "", n = 2, prefix = "t", make.numeric = FALSE)
}
\arguments{
\item{cap_hist}{A vector of capture histories.}

\item{sep}{What separates the individual history values}

\item{n}{Number of sampling events in each history}

\item{prefix}{Prefix for labeling columns of matrix}

\item{make.numeric}{Change the expanded columns to numeric from character?}
}
\value{
A matrix of capture histories with 1 column per sampling event
}
\description{
Split a vector of capture histories into a matrix with one column for each occasion
}
\details{
@template data.cap_hist
}
\examples{

# standard 2 character capture histor
data(data_rodli)
Petersen::split_cap_hist(data_rodli$cap_hist)

# history vector with ".." separating the fields
test <- c("1..1","1..0")
split_cap_hist(test, sep=stringr::fixed(".."))

}
