% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_VDJ_plot.R
\name{Spatial_VDJ_plot}
\alias{Spatial_VDJ_plot}
\title{Plotting immune repertoire data as clonotype or isotype for cells on a spatial image.}
\usage{
Spatial_VDJ_plot(
  sample_names,
  bcs_merge,
  images_tibble,
  title,
  size,
  legend_title,
  vgm_VDJ,
  analysis
)
}
\arguments{
\item{sample_names}{Character vector containing the name of the sample.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}

\item{legend_title}{Character vector to name the legend scale.}

\item{vgm_VDJ}{Data frame containing VDJ information, found in the vgm made by platypus. It must have x and y coordinates column and the column containing the factor to plot.}

\item{analysis}{Column in the dataframe containing the factor of interest to plot on the spatial image.}
}
\value{
Returns a plot of the factor of interest express on a spatial image.
}
\description{
Plotting immune repertoire data as clonotype or isotype for cells on a spatial image.
}
\examples{
\dontrun{
Spatial_VDJ_plot(vgm_VDJ = top_5_VDJ_data,analysis = top_5_VDJ_data$VDJ_cgene,
images_tibble = scaling_parameters[[5]], bcs_merge = scaling_parameters[[10]],
sample_names = sample_names, title = "B cell", legend = "Isotype")
}
}
