% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PD.R
\name{PD}
\alias{PD}
\title{Polycross Designs}
\usage{
PD(v, type)
}
\arguments{
\item{v}{v is number of genotypes}

\item{type}{type used for generating designs}
}
\value{
This function generates polycross designs using various methods for a given number of genotypes (v).
}
\description{
This package contains function for generating polycross designs using nine methods available in literature.

type1: v(>2) such that (v+1) is a prime number;

type1 is a series of polycross designs generated using the method given by Olesen and Olesen (1973).

type2: v (>2) is taken such that (v+1) is a prime number;

type2 is a series of completely balanced polycross designs generated using the method given by Olesen (1976).

type3: v(>2) is any integer;

type3 is a series of polycross designs with complete neighbour balance generated using the method given by Morgan (1988).

type4: v=5,7,9 or 11.

type4 is a series of balanced polycross designs given by Morgan(1988).

type5: v (>2) is taken in such a way that (v+1) is a prime number;

type5 is a series of Neighbour-balanced polycross designs for v genotypes (where v+1 is prime) for polycross trials as given in Varghese et al. (2015).

type6: v (>4) is any odd number;

type6 is a series of Neighbour-balanced polycross designs for v genotypes (where v is an odd number) for polycross trials as given in Varghese et al. (2015).

type7: v(>2)= 2*m, where, m is an odd positive integer;

type7 is a series of Neighbour-restricted block designs for polycross trials as given in Varghese et al. (2015).

type8: v = 4*m, where m is any positive integer;

type8 is a series of Neighbour-restricted row–column designs for polycross trials as given in Varghese et al. (2015).

type9: v is a prime number but (v-1) should be a multiple of 3;

type9 is a series of Polycross designs for directional wind system for polycross trials as given in Varghese et al. (2015).
}
\examples{
library(PolycrossDesigns)
PD(6,"type7")
}
\references{
1) Morgan (1988a)<doi: 10.1007/BF00025112>."Polycross Designs with Complete Neighbour Balance".

2) Morgan (1988b)(<doi:10.1111/j.2517-6161.1988.tb01714.x>."Balanced Polycross Designs".

3) Olesen  and Olesen (1973) < https://doi.org/10.1007/BF00036647>. "A Polycross Pattern Formula".

4) Olesen( 1976) <https://doi.org/10.1007/BF00041582>."A Completely Balanced Polycross Design".

5) Varghese et al. (2015) <doi:10.1080/02664763.2015.1043860>. " Experimental Designs for Open Pollination in Polycross Trials".
}
\author{
1) Cini Varghese, Division of Design of Experiments, ICAR-IASRI, New Delhi.

2) Seema Jaggi, Agricultural Education Division, ICAR, Krishi Anusandhan Bhawan - II, Pusa, New Delhi.

3) Eldho Varghese, Fishery Resources Assessment & Economics Division, ICAR-CMFRI, Kochi.

4) Ashutosh Dalal, Division of Design of Experiments, ICAR-IASRI, New Delhi.

5) Arpan Bhowmik, Division of Design of Experiments, ICAR-IASRI, New Delhi.
}
