\name{blockopt_2}
\alias{blockopt_2}
\title{Summarize your optimization settings for optimization routines}
\usage{
blockopt_2(fn, poped.db, opt_method = "")
}
\arguments{
  \item{opt_method}{If "RS" (random search), "SG"
  (stochastic gradient) or "DO" (discrete optimization)
  then specifc output is produced.}

  \item{poped.db}{A PopED database.}

  \item{fn}{The file handle to write to.}
}
\description{
Create some output to the screen and a text file that
summarizes the optimization settings you will use to
optimize.
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error to 
##   avoid sample times at very low concentrations (time 0 or very late samoples).
library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.add.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70,
                                  mina=0,
                                  maxa=100)
# warfarin optimization model 

blockopt_2(fn="",poped.db,opt_method="SG")
blockopt_2(fn="",poped.db,opt_method="RS")
blockopt_2(fn="",poped.db,opt_method="DO")
}
\seealso{
Other Helper: \code{\link{blockexp}};
\code{\link{blockfinal_2}}; \code{\link{blockheader_2}}
}

