/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.openfast.Message;
import org.openfast.logging.FastMessageLogger;
import org.openfast.template.MessageTemplate;

public class FileFastMessageLogger
implements FastMessageLogger {
    private final File file;
    private OutputStream out;

    public FileFastMessageLogger(String filePath) {
        this(new File(filePath));
    }

    public FileFastMessageLogger(File f) {
        if (f.exists() && !f.canWrite()) {
            throw new IllegalArgumentException("Unable to write to file: " + f.getAbsolutePath());
        }
        this.file = f;
    }

    public void log(Message message, byte[] bytes, FastMessageLogger.Direction direction) {
        try {
            this.createOut();
            this.out.write(new Date().toString().getBytes());
            this.out.write(10);
            this.out.write(((Object)((Object)direction) + "  ").getBytes());
            this.out.write(this.print(message));
            this.out.write(10);
            this.out.write(bytes);
            this.out.write(10);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] print(Message message) {
        StringBuilder msgBuilder = new StringBuilder();
        MessageTemplate template = message.getTemplate();
        msgBuilder.append(template.getName()).append("[ ");
        int i = 1;
        while (i < template.getFieldCount()) {
            msgBuilder.append(template.getField(i).getName()).append('=');
            if (message.isDefined(i)) {
                msgBuilder.append(message.getString(i));
            } else {
                msgBuilder.append("null");
            }
            msgBuilder.append(' ');
            ++i;
        }
        msgBuilder.append(']');
        return msgBuilder.toString().getBytes();
    }

    private void createOut() throws IOException {
        if (this.out == null) {
            if (!this.file.exists()) {
                if (!this.file.getParentFile().exists()) {
                    this.file.getParentFile().mkdirs();
                }
                this.file.createNewFile();
            }
            this.out = new FileOutputStream(this.file, true);
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

