/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import org.openfast.IntegerValue;
import org.openfast.ScalarValue;
import org.openfast.template.LongValue;
import org.openfast.template.type.codec.TypeCodec;
import org.openfast.util.Util;

public abstract class IntegerCodec
extends TypeCodec {
    private static final long serialVersionUID = 1L;

    protected IntegerCodec() {
    }

    protected static ScalarValue createValue(long value) {
        if (Util.isBiggerThanInt(value)) {
            return new LongValue(value);
        }
        return new IntegerValue((int)value);
    }

    public static int getUnsignedIntegerSize(long value) {
        if (value < 128L) {
            return 1;
        }
        if (value <= 16384L) {
            return 2;
        }
        if (value <= 0x200000L) {
            return 3;
        }
        if (value <= 0x10000000L) {
            return 4;
        }
        if (value <= 0x800000000L) {
            return 5;
        }
        if (value <= 0x40000000000L) {
            return 6;
        }
        if (value <= 0x2000000000000L) {
            return 7;
        }
        if (value <= 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static int getSignedIntegerSize(long value) {
        if (value >= -64L && value <= 63L) {
            return 1;
        }
        if (value >= -8192L && value <= 8191L) {
            return 2;
        }
        if (value >= -1048576L && value <= 1048575L) {
            return 3;
        }
        if (value >= -134217728L && value <= 0x7FFFFFFL) {
            return 4;
        }
        if (value >= -17179869184L && value <= 0x3FFFFFFFFL) {
            return 5;
        }
        if (value >= -2199023255552L && value <= 0x1FFFFFFFFFFL) {
            return 6;
        }
        if (value >= -281474976710656L && value <= 0xFFFFFFFFFFFFL) {
            return 7;
        }
        if (value >= -36028797018963968L && value <= 0x7FFFFFFFFFFFFFL) {
            return 8;
        }
        if (value >= -4611686018427387904L && value <= 0x3FFFFFFFFFFFFFFFL) {
            return 9;
        }
        return 10;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

