// Title: Statistique de test S dans notre second article (2016) avec Alain ... (avant c'était dl5 dans Pkurtosis_16oct2009.pdf)
// Ref. (book or article): 

#include <R.h>
#include "Rmath.h"
// // #undef min
// // #define min(a,b) ((a < b)?a:b)
// // #undef max
// // #define max(a,b) ((a > b)?a:b)

extern "C" {

  typedef double optimfn(int n, double *par, void *ex);
  typedef void optimgr(int n, double *par, double *gr, void *ex);
  void lbfgsb(int n, int lmm, double *x, double *lower,
	      double *upper, int *nbd, double *Fmin, optimfn fn,
	      optimgr gr, int *fail, void *ex, double factr,
	      double pgtol, int *fncount, int *grcount,
	      int maxit, char *msg, int trace, int nREPORT);

  void myoptimgrS(int n, double *par, double *gr, void *ex) {
    double quantileestimS(int n, double *par, void *ex);
    double *parh;
    parh = new double[1];
    parh[0] = par[0] + 0.0000000001;
    gr[0] = (quantileestimS(1, parh, ex) - quantileestimS(1, par, ex)) / 0.0000000001;
    delete[] parh;
  }

  double quantileestimS(int n, double *par, void *ex) {
  // n should be 1, and par[0] is alpha, and ex[0] is nsize (sample size) and ex[1] is stat
    double res, factinterp, q1 = 0.0, q2 = 0.0;
    int i;
    int nsize = (int)(((double*)ex)[0]);

    // Computed with M = 10 ^ 7
    double coeff[100][9] = {{3.9017,-6.6994,10.4214,-22.9919,36.3846,-39.5895,26.6263,-9.9541,1.5910},
			    {4.1292,-8.2085,15.4813,-32.6862,46.9256,-45.4768,27.5495,-9.4272,1.4013},
			    {4.1364,-7.4175,9.8565,-14.8065,14.6730,-10.4746,4.9171,-1.3915,0.1935},
			    {4.1656,-7.2811,9.1005,-14.3608,17.6119,-17.5650,11.8528,-4.6245,0.7845},
			    {4.3525,-8.7690,14.5912,-25.1781,28.9988,-22.8490,11.3178,-3.1747,0.3928},
			    {4.2727,-7.1976,5.5346,1.2142,-15.8252,23.3818,-17.2053,6.5026,-0.9961},
			    {4.6563,-11.5465,27.1126,-57.9131,81.6399,-75.7355,43.6493,-14.1654,1.9826},
			    {4.4517,-8.6919,12.2302,-16.6999,14.0250,-7.9263,2.8470,-0.6413,0.0847},
			    {4.8031,-12.5553,30.7655,-65.6267,91.2425,-82.6207,46.2158,-14.5028,1.9569},
			    {4.7624,-11.9189,27.8655,-59.1285,83.1485,-76.9614,44.1743,-14.2345,1.9702},
			    {4.7304,-11.1060,22.2678,-40.0193,45.9441,-33.8805,14.8515,-3.4100,0.2983},
			    {4.6377,-10.1233,19.0934,-36.6529,48.9103,-44.8645,26.0063,-8.5447,1.2139},
			    {4.8014,-11.4621,23.5023,-43.6914,53.7724,-44.2980,22.9438,-6.7615,0.8690},
			    {4.8297,-11.6588,24.0524,-43.8032,51.3322,-39.0154,17.9685,-4.4876,0.4574},
			    {4.7539,-10.7788,20.4073,-36.3991,43.6424,-35.8156,18.8053,-5.7056,0.7647},
			    {4.7777,-10.7476,19.4499,-32.2084,34.4107,-24.0436,10.0408,-2.1797,0.1739},
			    {4.6571,-9.2649,12.4581,-14.8872,9.3525,-2.1800,-1.2494,0.9801,-0.1925},
			    {4.8033,-10.8851,20.0952,-34.4049,38.9298,-29.5512,13.9670,-3.7040,0.4239},
			    {4.8367,-11.1008,20.8634,-36.0560,41.1676,-31.5496,15.1214,-4.0850,0.4755},
			    {4.7504,-9.8600,14.0683,-16.2447,7.0475,4.2479,-7.3476,3.6620,-0.6516},
			    {5.1590,-14.6272,37.7093,-80.8074,113.2946,-103.8506,59.1905,-19.0357,2.6396},
			    {5.1236,-14.2505,35.7511,-74.4137,100.1560,-87.3330,46.9776,-14.1781,1.8391},
			    {4.9013,-11.8608,25.4790,-50.8206,68.1017,-60.6912,33.6341,-10.4709,1.3996},
			    {5.1749,-14.7914,39.0838,-86.0427,123.7357,-115.7859,67.1231,-21.9021,3.0761},
			    {4.8625,-11.1497,21.3056,-38.5072,47.4614,-40.3197,21.9932,-6.9390,0.9643},
			    {4.9554,-11.9624,24.3384,-44.7243,55.1130,-46.1113,24.6041,-7.5629,1.0206},
			    {4.8230,-10.0676,13.9601,-14.5463,3.2992,8.1718,-9.5233,4.2753,-0.7218},
			    {5.2411,-15.3930,42.0150,-94.1680,137.0067,-128.6699,74.3195,-23.9926,3.3118},
			    {5.0415,-12.7808,28.0272,-53.6470,67.2031,-55.1362,27.8460,-7.8080,0.9240},
			    {5.0200,-12.4025,25.8249,-47.2689,56.8897,-45.5503,22.8963,-6.5610,0.8218},
			    {4.5583,-6.7957,-2.1248,28.6554,-66.9343,79.1776,-53.1446,19.1621,-2.8833},
			    {5.0467,-12.5675,26.4404,-48.7818,59.0750,-47.2084,23.3894,-6.4987,0.7744},
			    {5.2024,-14.6755,38.0095,-82.9044,118.9821,-111.7619,65.2554,-21.4832,3.0456},
			    {5.0393,-12.5564,26.8948,-51.6107,66.6071,-57.9533,31.9095,-10.0326,1.3715},
			    {5.1300,-13.9542,35.4340,-78.5199,115.4265,-111.0478,66.1301,-22.0917,3.1625},
			    {4.9844,-11.7138,22.0340,-36.2655,37.6185,-24.5515,8.9744,-1.4238,0.0130},
			    {5.1396,-13.5943,31.8695,-64.5680,86.2400,-75.6132,41.0835,-12.5225,1.6346},
			    {4.9738,-11.4593,20.7198,-33.4599,35.0296,-24.2589,10.2470,-2.3333,0.2102},
			    {5.0642,-12.4568,25.0243,-42.8538,46.3609,-31.8360,12.7849,-2.6000,0.1808},
			    {5.0913,-13.0637,29.6979,-60.0513,81.2055,-72.9564,40.9563,-12.9830,1.7719},
			    {5.1507,-13.6959,32.2726,-65.5593,88.2231,-78.5855,43.8133,-13.8404,1.8893},
			    {5.1125,-12.5672,24.5890,-40.6706,42.6257,-28.7664,11.6734,-2.5590,0.2308},
			    {5.0650,-12.2368,24.1720,-42.3854,49.2662,-38.5675,19.0855,-5.3963,0.6647},
			    {4.9999,-11.4848,21.0614,-35.6538,40.7891,-32.3065,16.5707,-4.9751,0.6663},
			    {5.1717,-13.6014,32.1823,-67.6523,95.6715,-89.8296,52.6622,-17.4124,2.4744},
			    {5.0138,-11.5500,20.9882,-33.8300,34.1458,-21.0167,6.4423,-0.3405,-0.1862},
			    {5.0565,-11.7936,21.3552,-33.3062,31.9517,-18.5228,5.3178,-0.2525,-0.1390},
			    {5.2145,-13.8531,32.6200,-66.6174,90.2879,-80.7783,45.0452,-14.1710,1.9180},
			    {5.4786,-16.9285,47.7373,-107.3100,155.7615,-145.3359,83.2430,-26.6128,3.6322},
			    {5.3595,-15.1953,38.0268,-78.9614,107.8111,-96.6526,54.0167,-17.0656,2.3264},
			    {5.0996,-12.2005,23.4305,-39.2760,41.9947,-28.6254,11.2954,-2.1722,0.1192},
			    {5.2313,-13.6003,30.2767,-58.6662,75.9567,-65.7219,35.7738,-11.0682,1.4830},
			    {5.3035,-14.6130,35.8347,-74.2355,101.1146,-90.3620,50.3161,-15.8525,2.1593},
			    {4.8533,-8.7570,4.9974,12.9087,-45.1430,60.2294,-43.1488,16.2547,-2.5291},
			    {5.2335,-13.6385,30.5882,-59.6529,77.6118,-67.3927,36.8250,-11.4572,1.5476},
			    {5.2160,-12.9897,25.5003,-41.2863,41.1784,-25.2155,8.4087,-1.1294,-0.0178},
			    {5.0435,-11.1889,18.3837,-27.0582,25.5959,-16.1757,6.2937,-1.3511,0.1220},
			    {5.1667,-12.7024,25.6790,-45.7850,54.2038,-43.1320,21.6871,-6.2345,0.7814},
			    {5.3410,-14.6984,35.2812,-71.1416,94.4923,-82.6378,45.0759,-13.8949,1.8467},
			    {5.2887,-14.1710,33.2191,-66.9028,89.3351,-78.7494,43.2730,-13.4210,1.7926},
			    {4.7349,-7.3147,-1.5558,28.4995,-66.6195,77.6272,-51.0465,17.9769,-2.6376},
			    {5.3185,-14.4307,34.1966,-68.5755,90.1829,-77.5570,41.2981,-12.3585,1.5896},
			    {5.1603,-12.4566,24.4703,-43.1903,51.4127,-41.8812,21.9104,-6.6555,0.8937},
			    {4.8488,-8.8370,6.9960,2.8664,-21.3409,28.9572,-19.8009,6.9830,-1.0092},
			    {5.3283,-14.2340,32.3079,-61.8412,77.6501,-64.2156,33.0838,-9.6223,1.2059},
			    {5.2432,-13.3641,28.3732,-51.9183,62.5482,-50.0561,25.1197,-7.1737,0.8917},
			    {4.9298,-9.9755,13.2474,-15.0709,8.4806,-0.7603,-2.3330,1.4155,-0.2702},
			    {5.1990,-12.5899,23.5355,-36.6076,34.8768,-20.3016,6.2997,-0.7104,-0.0378},
			    {5.1278,-11.9648,21.7232,-34.9013,36.2869,-24.6950,10.0318,-2.0962,0.1506},
			    {5.1976,-12.5899,24.1420,-40.3135,44.3067,-32.9052,15.5840,-4.2810,0.5226},
			    {5.1817,-12.3092,22.3288,-34.4403,33.4575,-20.9447,7.8011,-1.5236,0.1124},
			    {5.0851,-11.4417,19.0187,-27.3143,23.7384,-12.1491,2.6024,0.2934,-0.1696},
			    {4.9049,-9.3210,8.3641,2.4030,-26.3845,40.1306,-30.3531,11.7920,-1.8730},
			    {5.1217,-11.7096,19.4033,-25.4799,16.0148,0.0991,-7.3094,4.3699,-0.8468},
			    {5.2268,-13.2281,28.7741,-56.6591,76.7398,-71.0263,41.9050,-14.1343,2.0639},
			    {5.3761,-14.5859,33.5860,-64.7000,81.8608,-68.3028,35.5773,-10.4793,1.3306},
			    {5.3880,-15.2892,39.4311,-86.0264,124.3478,-117.8904,69.4695,-23.0566,3.2891},
			    {5.3423,-14.3386,32.9861,-64.3939,83.0424,-70.8157,37.7333,-11.3673,1.4746},
			    {5.2504,-12.7942,23.8326,-36.5413,33.7144,-17.9015,3.8683,0.5161,-0.2819},
			    {5.1834,-12.6129,25.0393,-44.1882,52.2148,-42.0751,21.8099,-6.5937,0.8853},
			    {5.1155,-11.6971,20.8134,-34.5324,39.7930,-32.6851,17.6913,-5.6261,0.7905},
			    {5.3220,-14.2246,33.3655,-68.1985,93.6330,-85.5140,48.8539,-15.7598,2.1856},
			    {5.1192,-11.6698,20.2727,-32.0021,34.1871,-25.8645,13.0094,-3.9273,0.5380},
			    {5.6026,-17.3766,47.6781,-103.0470,143.9848,-130.1310,72.7018,-22.8302,3.0800},
			    {5.3581,-14.3237,32.0094,-59.6860,72.9366,-59.2428,30.4661,-9.0397,1.1847},
			    {5.0960,-11.6255,20.8553,-34.8216,39.5804,-31.1875,15.7857,-4.6080,0.5879},
			    {4.9656,-9.7001,9.6643,-0.8771,-20.3361,32.7592,-24.9177,9.6145,-1.5104},
			    {5.2711,-13.8143,32.0396,-65.9882,91.7478,-85.0245,49.2946,-16.1333,2.2695},
			    {5.2431,-13.3058,28.3753,-52.8952,65.7124,-54.7805,28.8795,-8.7112,1.1450},
			    {5.2175,-13.1002,28.2512,-55.3100,74.0199,-67.1198,38.4818,-12.5441,1.7657},
			    {5.2540,-13.3791,29.1231,-56.7458,75.2885,-67.5940,38.4037,-12.4287,1.7410},
			    {5.3531,-14.4661,33.8337,-67.2289,88.1931,-76.1452,40.8553,-12.3252,1.5932},
			    {5.3721,-14.6083,34.3139,-68.5391,91.1455,-80.5313,44.6327,-14.0257,1.9027},
			    {5.2536,-13.3566,28.5861,-53.6960,67.7187,-57.7400,31.3624,-9.8086,1.3435},
			    {5.2807,-13.5121,28.8597,-53.2546,64.6542,-51.6516,25.4470,-6.9628,0.8021},
			    {5.0368,-10.7001,15.0321,-15.8952,4.3892,7.7270,-9.5125,4.3142,-0.7284},
			    {5.4104,-15.3215,39.0190,-83.9137,119.6463,-112.0179,65.1902,-21.3523,3.0020},
			    {5.3790,-14.9432,36.9850,-77.7167,108.2773,-99.2831,56.6817,-18.2408,2.5230},
			    {5.0430,-10.4924,13.0624,-8.8398,-9.0123,22.5900,-19.2219,7.7873,-1.2539},
			    {5.1819,-12.7447,26.7680,-51.6795,68.0098,-60.2210,33.3454,-10.3761,1.3787}};

    int npoints[100] = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000, 2250, 2500, 2750, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, 6000, 7000, 8000, 9000, 10000, 20000};

    int i1, i2;
    if (nsize >= 20000) {
      i1 = 99;
      i2 = 100;
    } else if (nsize <= 10) {
      i1 = 1;
      i2 = 2;
    } else {
      for(i = 1; i <= 100; i++) {
	if (nsize <= npoints[i - 1]) break;
      }
      i2 = i;
      i1 = i2 - 1;
    }

    int n1 = npoints[i1 - 1];
    int n2 = npoints[i2 - 1];

    factinterp = (double)(nsize - n1) / (double)(n2 - n1);

    for (i = 1; i <= 9; i++) {
      q1 = q1 + coeff[i1 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.2017955), i - 1); // I replaced -log(par[0]) with fabs(log(par[0])) pour des raisons d'arrondis numériques
      q2 = q2 + coeff[i2 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.2017955), i - 1);
    }

    res = q2 * factinterp + q1 * (1.0 - factinterp);
    res = R_pow(res - ((double*)ex)[1], 2.0);
    
    return res;
  }

  void stat37(double *x, int *xlen, double *level, int *nblevel, char **name, int *getname, double *statistic, int *pvalcomp, double *pvalue, double *critvalL, double *critvalR, int *usecrit, int *alter, int *decision, double *paramstat, int *nbparamstat) {

// If the test statistic can only be in category 3 or 4 (see just below), INDICATE the following line accordingly. Else, leave it commented.
// 0: two.sided=bilateral, 1: less=unilateral, 2: greater=unilateral, 3: bilateral test that rejects H0 only for large values of the test statistic, 
// 4: bilateral test that rejects H0 only for small values of the test statistic
    if (alter[0] != 0 && alter[0] != 1 && alter[0] != 2) error("alter should be in {0,1,2}");

    int i, j=0, n=xlen[0];
    if (getname[0] == 1) {    
// Here, INDICATE the name of your statistic
      const char *nom = "$S_2$";
// Here, INDICATE the number of parameters of your statistic
      nbparamstat[0] = 0;
// Here, INDICATE the default values of the parameters:
      if (name[0][0] == '1') { // To prevent writing in a non declared address (because maybe paramstat has not be initialized with a sufficient length since the correct value of nbparamstat[0] may be unkown yet).

     }
// The following 7 lines should NOT be modified
      const char *space = " ";
      while (nom[j] != '\0') {
	name[j][0] = nom[j];
	j++;
      }
      for (i=j;i<50;i++) name[i][0] = space[0];
      return;
    }

    if (n>3) {
// Computation of the value of the test statistic
//    double qnorm(double p, double mean, double sd, int lower_tail, int log_p);
//    double pnorm5(double x, double mu, double sigma, int lower_tail, int log_p);
    double *zchap, S = 0.0;
    zchap = new double[n];
    //    double gamma = 0.577215664901533, sigchap;
    double muchap = 0.0, sigchap2 = 0.0, statvalue;

    for (i = 0; i < n; i++) muchap = muchap + x[i];
    muchap = muchap / (double)n;

    for (i = 0; i < n; i++) sigchap2 = sigchap2 + R_pow(x[i] - muchap, 2.0);
    sigchap2 = sigchap2 / (double)n;

    for (i = 0; i < n; i++) {
      zchap[i] = (x[i] - muchap);
      S = S + zchap[i] * fabs(zchap[i]);
    }

    // S is equal to n * sigchap2 * skewness_APD

    statvalue = S / (sigchap2 * sqrt((double)n * (3.0 - 8.0 / M_PI))); // statvalue is equal to sqrt((1.0 - 1.9 / n)) * skewness_trans_APD

    statistic[0] = statvalue; // Here is the test statistic value

    if (pvalcomp[0] == 1) {
      // If possible, computation of the p-value.
      #include "pvalues/pvalue37.cpp"
    }

// We take the decision to reject or not to reject the null hypothesis H0
    for (i=0;i<=(nblevel[0]-1);i++) {      
	if (usecrit[0] == 1) { // We use the provided critical values
	  if (alter[0] == 0) { if (statistic[0] > critvalR[i] || statistic[0] < critvalL[i]) decision[i] = 1; else decision[i] = 0; // two-sided
	  } else if (alter[0] == 1) {  if (statistic[0] < critvalL[i]) decision[i] = 1; else decision[i] = 0;  // less
	    } else { if (alter[0] == 2) {  if (statistic[0] > critvalR[i]) decision[i] = 1; else decision[i] = 0; } } // greater
      } else {
	    if (pvalue[0] < level[i]) decision[i] = 1; else decision[i] = 0; // We use the p-value
      }
    }
    
// If applicable, we free the unused array of pointers
    delete[] zchap;

}

// We return
    return;
    
        
  }
 
 
}

