## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
library(PowerUpR)

## ----  message=FALSE, eval=FALSE-----------------------------------------
#  install.packages("PowerUpR")

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.ira1r1(power=.80, n=250)
power.ira1r1(es=d1$mdes[1], n=250)
mrss.ira1r1(es=d1$mdes[1])

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bira2c1(power=.80, n=15, J=20)
power.bira2c1(es=d1$mdes[1], n=15, J=20)
mrss.bira2c1(es=d1$mdes[1], n=15)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bira2f1(power=.80, n=15, J=20)
power.bira2f1(es=d1$mdes[1], n=15, J=20)
mrss.bira2f1(es=d1$mdes[1], n=15)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bira2r1(power=.80, rho2=.17, omega2=.50, n=15, J=20)
power.bira2r1(es=d1$mdes[1], rho2=.17, omega2=.50, n=15, J=20)
mrss.bira2r1(es=d1$mdes[1], rho2=.17, omega2=.50, n=15)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.cra2r2(power=.80, rho2=.17, n=15, J=20)
power.cra2r2(es=d1$mdes[1], rho2=.17, n=15, J=20)
mrss.cra2r2(es=d1$mdes[1], rho2=.17, n=15)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bcra3f2(power=.80, rho2=.10, n=20, J=44, K=5)
power.bcra3f2(es=d1$mdes[1], rho2=.10, n=20, J=44, K=5)
mrss.bcra3f2(es=d1$mdes[1], rho2=.10, n=20, J=44)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bira3r1(power=.80, rho3=.20, rho2=.15,
                   omega3=.10, omega2=.10,
                   n=69, J=10, K=100)
power.bira3r1(es=d1$mdes[1], rho3=.20, rho2=.15,
              omega3=.10, omega2=.10,
              n=69, J=10, K=100)
mrss.bira3r1(es =d1$mdes[1], rho3=.20, rho2=.15,
             omega3=.10, omega2=.10,
             n=69, J=10)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bcra3r2(power=.80, rho3=.13, rho2=.10, omega3=.4,
                   n=10, J=6, K=24)
power.bcra3r2(es=d1$mdes[1], rho3=.13, rho2=.10, omega3=.4,
              n=10, J=6, K=24)
mrss.bcra3r2(es=d1$mdes[1], rho3=.13, rho2=.10, omega3=.4,
             n=10, J=6)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.cra3r3(power=.80, rho3=.06, rho2=.17, n=15, J=3, K=60)
power.cra3r3(es=d1$mdes[1], rho3=.06, rho2=.17, n=15, J=3, K=60)
mrss.cra3r3(es=d1$mdes[1], rho3=.06, rho2=.17, n=15, J=3)


## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bcra4f3(power=.80, rho3=.15, rho2=.15,
                   n=10, J=4, K=4, L=15)
power.bcra4f3(es=d1$mdes[1], rho3=.15, rho2=.15,
              n=10, J=4, K=4, L=15)
mrss.bcra4f3(es=d1$mdes[1], rho3=.15, rho2=.15,
             n=10, J=4, K=4)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bira4r1(power=.80, rho4=.05, rho3=.15, rho2=.15,
                   omega4=.50, omega3=.50, omega2=.50,
                   n=10, J=4, K=4, L=27)
power.bira4r1(es=d1$mdes[1], rho4=.05, rho3=.15, rho2=.15,
              omega4=.50, omega3=.50, omega2=.50,
              n=10, J=4, K=4, L=27)
mrss.bira4r1(es=d1$mdes[1], rho4=.05, rho3=.15, rho2=.15,
             omega4=.50, omega3=.50, omega2=.50,
             n=10, J=4, K=4)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bcra4r2(power=.80, rho4=.05, rho3=.15, rho2=.15,
                   omega4=.50, omega3=.50, n=10, J=4, K=4, L=20)
power.bcra4r2(es=d1$mdes[1], rho4=.05, rho3=.15, rho2=.15,
              omega4=.50, omega3=.50, n=10, J=4, K=4, L=20)
mrss.bcra4r2(es=d1$mdes[1], rho4=.05, rho3=.15, rho2=.15,
             omega4=.50, omega3=.50, n=10, J=4, K=4)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.bcra4r3(power=.80, rho4=.05, rho3=.15, rho2=.15,
                   omega4=.50, n=10, J=4, K=4, L=20)
power.bcra4r3(es=d1$mdes[1], rho4=.05, rho3=.15, rho2=.15,
              omega4=.50, n=10, J=4, K=4, L=20)
mrss.bcra4r3(es=d1$mdes[1], rho4=.05, rho3=.15, rho2=.15,
             omega4=.50, n=10, J=4, K=4)

## ---- message=FALSE------------------------------------------------------
d1 <- mdes.cra4r4(power=.80, rho4=.05, rho3=.05, rho2=.10,
                  n=10, J=2, K=3, L=20)
power.cra4r4(es=d1$mdes[1], rho4=.05, rho3=.05, rho2=.10,
             n=10, J=2, K=3, L=20)
mrss.cra4r4(es=d1$mdes[1], rho4=.05, rho3=.05, rho2=.10,
            n=10, J=2, K=3)

