% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{matched_fig}
\alias{matched_fig}
\title{Providing a matched_index() function dependant on time}
\usage{
matched_fig(data, start, end, type = "prodID", fixedbase = TRUE, figure = TRUE)
}
\arguments{
\item{data}{The user's data frame. It must contain a column \code{time} (as Date in format: year-month-day,e.g. '2020-12-01') and also a column indicated by the \code{type} parameter.}

\item{start}{The base period (as character) limited to the year and month, e.g. "2019-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2019-04".}

\item{type}{This parameter defines the column which is used in the procedure. Possible values of the \code{type} parameter are: \code{retID}, \code{prodID}, \code{codeIN}, \code{codeOUT} or \code{description}.}

\item{fixedbase}{A logical parameter indicating whether the procedure is to work for subsequent months from the considered time interval (\code{fixedbase}=FALSE). Otherwise the month defined by \code{start} plays a role of fixed base month (\code{fixedbase}=TRUE)}

\item{figure}{A logical parameter indicating whether the function returns a figure (TRUE) or a data frame (FALSE) with \code{\link{matched_index}} values.}
}
\value{
The function returns a data frame or a figure presenting the \code{\link{matched_index}} function calculated for the column defined by the \code{type} parameter and for each month from the considered time interval. The interval is set by \code{start} and \code{end} parameters. The returned object (data frame or figure) depends on the value of \code{figure} parameter. The returned values belong to [0,1].
}
\description{
The function provides a data frame or a figure presenting the \code{\link{matched_index}} function calculated for the column defined by the \code{type} parameter and for each month from the considered time interval
}
\examples{
\donttest{matched_fig(milk, start="2018-12", end="2019-12")}
\donttest{matched_fig(milk, start="2018-12", end="2019-12", figure=FALSE)}
}
