% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDDN.R
\name{getDDN}
\alias{getDDN}
\title{getDDN}
\usage{
getDDN(drug.el, r.set, candidates, file = "network.html")
}
\arguments{
\item{drug.el}{A edge list of drugs, which is a two-column matrix, each row defines one edge. Numbers in the edge list represent NSC-ID of drugs.}

\item{r.set}{A set of drugs that you used to prioritize candidates.}

\item{candidates}{A set of drugs that have been prioritized.}

\item{file}{file = "network.html"(default). File name and path where to save the HTML web page. Currently only .html formats are supported.}
}
\value{
A HTML web page within drug drug similarity network
}
\description{
This function is used to generate drug drug similarity network.
}
\examples{
e <- getData("drug.edgelist")
brc <- getData("breast_cancer")
candidates <- getData("brc_candidates")
getDDN(e, brc, candidates)
}
