% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_house_senate_floor_actions.R
\name{get_recent_house_senate_floor_actions}
\alias{get_recent_house_senate_floor_actions}
\title{Get Recent House and Senate Floor Actions}
\usage{
get_recent_house_senate_floor_actions(congress, chamber, myAPI_Key)
}
\arguments{
\item{congress}{114-115 for House, 96-115 for Senate}

\item{chamber}{house or senate}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent results and supports pagination using multiples of 20. The date attribute represents the “legislative day” in which the action took place (actions that occur after midnight often are part of the previous day’s activity).
}
\description{
To get the latest actions from the House or Senate floor, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/{chamber}/floor_updates.json
}
\examples{
\donttest{
get_recent_house_senate_floor_actions(115, 'house')
}
}
