% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_electronic_filing_by_types.R
\name{get_electronic_filing_by_types}
\alias{get_electronic_filing_by_types}
\title{Get Electronic Filings By Type}
\usage{
get_electronic_filing_by_types(cycle = 2018, form_type_id, page = 1, myAPI_Key)
}
\arguments{
\item{cycle}{The election cycle}

\item{form_type_id}{F + integer. To get form type IDs, use an electronic filing form types request.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves a list of available form types for FEC electronic filings.
}
\description{
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/filings/types/{form-type-id}
}
\examples{
\dontrun{
get_electronic_filing_by_types(2016, 'F24')
get_electronic_filing_by_types(2016, 
matrix(unlist(get_electronic_filing_form_types(2016)$results), 
ncol = 2, byrow = TRUE)[8])
#' }
}
