% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r, R/06PTModule.r
\docType{methods}
\name{name}
\alias{name}
\alias{name,PTSample-method}
\alias{name<-}
\alias{name<-,PTSample,character-method}
\alias{name,PTModule-method}
\alias{name<-,PTModule,character-method}
\title{Obtain or replace the name of a PTModule or PTSample}
\usage{
\S4method{name}{PTSample}(x)

\S4method{name}{PTSample,character}(x) <- value

\S4method{name}{PTModule}(x)

\S4method{name}{PTModule,character}(x) <- value
}
\arguments{
\item{x}{A \code{\link{PTModule}} or a \code{\link{PTSample}}
object for which to obtain or replace the name.}

\item{value}{A \code{character} string which should be used to replace the
name of \code{\link{PTModule}} or \code{\link{PTSample}} \code{x}.}
}
\value{
For \code{name}, the name of the \code{\link{PTModule}} or
\code{\link{PTSample}} object as a \code{character} string is returned.

For \code{name<-}, object \code{x} with an updated name is returned.
}
\description{
The name of both a \code{\link{PTModule}} and
\code{\link{PTSample}} are stored as \code{raw} data.
This method returns the name as a \code{character} string, or it can
be used to assign a new name to a \code{\link{PTModule}} or
\code{\link{PTSample}}.
}
\details{
The name of a \code{\link{PTModule}} and
\code{\link{PTSample}} is stored as a \code{vector} of
\code{raw} data with a length of 20 or 22 respectively. This method
provides the means for getting the name as a \code{character} string
or to safely redefine the name of a \code{\link{PTModule}} or
\code{\link{PTSample}} object. To do so,
the provided name (\code{value}) is converted to a \code{raw} \code{vector}
of length 20 or 22 respectively. Long names may therefore get clipped.
}
\examples{
data("mod.intro")

## get the name of mod.intro:
name(mod.intro)

## I don't like the name, let's change it:
name(mod.intro) <- "I like this name better"

## Note that the provided name was too long and is truncated:
name(mod.intro)

## print all sample names in the module:
unlist(lapply(as.list(1:31), function(x)
  name(PTSample(mod.intro, x))))

}
\seealso{
Other character.operations: \code{\link{as.character}},
  \code{\link{periodToChar}}, \code{\link{rawToCharNull}},
  \code{\link{sampleRate}}

Other sample.operations: \code{\link{PTSample-class}},
  \code{\link{PTSample-method}}, \code{\link{fineTune}},
  \code{\link{loopLength}}, \code{\link{loopSample}},
  \code{\link{loopStart}}, \code{\link{loopState}},
  \code{\link{playSample}}, \code{\link{read.sample}},
  \code{\link{sampleLength}}, \code{\link{volume}},
  \code{\link{waveform}}, \code{\link{write.sample}}
}
\author{
Pepijn de Vries
}
