% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelReserve.R
\name{parallelReserve}
\alias{parallelReserve}
\title{Parallel based development profile reserve}
\usage{
parallelReserve(
  chainLadder,
  method = "parallax",
  cum = TRUE,
  residuals = FALSE
)
}
\arguments{
\item{chainLadder}{cumulative or incremental run-off triangle (the triangle
must be of the class \code{triangle} or \code{matrix}) in terms of a square
matrix (i.e., a fully observed run-off triangle) or a standard run-off triangle
instead (i.e, the top-left triangular part of the matrix}

\item{method}{prediction method to be used: PARALLAX (DEFAULT
\code{method = "parallax"}) or REACT (\code{method = "react"})}

\item{cum}{logical (\code{TRUE} for a cumulative triangle and \code{FALSE} for
an incremental triangle)}

\item{residuals}{logical to indicate whether  incremental residuals should be
provided or not. If the run-off triangle is complete then the residuals are
obtained in terms of true increments minus the predicted increments. If the
bottom-right part of the triangle is not available the residuals are provided
in terms of the backfitting approach (see Maciak, Mizera, and Pesta (2022)
for further details)}
}
\value{
An object of the class \code{list} with with the following elements:
\item{reserve}{numeric vector with four values summarizing the reserve: Total
paid amount (i.e., the sum of the last observed diagonal in a cumulative run-off
triangle); Total estimated amount (i.e., the sum of the last column in the
completed cumulative triangle); Estimated reserve (i.e., the sum of the last
column in the completed cumulative triangle minus the sum of the last observed
diagonal in \code{chainLadder}); True reserve---if the completed (true)
\code{chainLadder} is provided in the input (i.e., the sum of the last column
in \code{chainLadder} minus the sum of the last diagonal in \code{chainLadder})}
\item{method}{algorithm used for the reserve estimation (PARALLAX or REACT)}
\item{completed}{completed functional development profiles (the
lower-right triangular part in \code{completed}) estimated by the
PARALLAX algorithm or the REACT algorithm}
\item{inputTriangle}{the run-off triangle considered as the input for the
underlying estimation algorithm (PARALLAX or REACT)}
\item{trueCompleted}{true (complete) run-off triangle (if available) and
\code{NA} value provided otherwise}
\item{residuals}{a triangle with the corresponding residuals (for
\code{residuals = TRUE}). The residuals are either provided in the upper-left
triangle (so-called back-fitted incremental residuals if true completed triangle
is not available) or the residuals are given in the lower-right triangle (i,e.,
standard incremental residuals---if the true completed triangle is given)}
}
\description{
The function takes a cumulative (or incremental) run-off triangle (partially
or completely observed) and returns the reserve estimate obtained by the
PARALLAX or REACT algorithm (see Maciak, Mizera, and Pešta (2022) for more
details). If the full square is provided as the input then the algorithms still
rely only on the partially observed data---run-off triangle only (i.e., the
top-left triangular part of the data)---when estimating the underlying reserve
but, in addition, incremental residuals (true increments minus predicted
increments) are returned for retrospective validation purposes. If the run-off
triangle is provided,then algorithm caclulates back-fitted (incremental)
residuals instead (see Maciak, Mizera, and Pešta (2022) for details).
}
\examples{
## run-off (upper-left) triangle with NA values (bottom-right part)
if (requireNamespace("ChainLadder")) {
data(MW2014, package = "ChainLadder")
print(MW2014) 
parallelReserve(MW2014, residuals = TRUE)}

## completed run-off triangle with 'unknown' truth (lower-bottom part)  
## for the estimation purposes only the upper-left triangle is used 
data(CameronMutual)
parallelReserve(CameronMutual, residuals = TRUE)

## the previous output is identical (in term of the reserve prediction) 
## but back-fitted residuals are provided in the output instead 
print(observed(CameronMutual))
parallelReserve(observed(CameronMutual), residuals = TRUE)


}
\references{
Maciak, M., Mizera, I., and Pešta, M. (2022). Functional Profile
Techniques for Claims Reserving. ASTIN Bulletin, 52(2), 449-482. DOI:10.1017/asb.2022.4
}
\seealso{
\code{\link[=permuteReserve]{permuteReserve()}}, \code{\link[=mcReserve]{mcReserve()}}
}
