% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{data_wordvec_load}
\alias{data_wordvec_load}
\alias{load_wordvec}
\alias{load_embed}
\title{Load word vectors data (\code{wordvec} or \code{embed}) from ".RData" file.}
\usage{
data_wordvec_load(
  file,
  as = c("wordvec", "embed"),
  normalize = FALSE,
  verbose = TRUE
)

load_wordvec(file, normalize = TRUE)

load_embed(file, normalize = TRUE)
}
\arguments{
\item{file}{File name of .RData transformed by \code{\link{data_transform}}.
Can also be an .RData file containing an embedding matrix with words as row names.}

\item{as}{Load as
\code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix).
Defaults to the original class of the R object in \code{file}.
The two wrapper functions \code{load_wordvec} and \code{load_embed}
automatically reshape the data to the corresponding class and
normalize all word vectors (for faster future use).}

\item{normalize}{Normalize all word vectors to unit length?
Defaults to \code{FALSE}. See \code{\link{normalize}}.}

\item{verbose}{Print information to the console? Defaults to \code{TRUE}.}
}
\value{
A \code{wordvec} (data.table) or \code{embed} (matrix).
}
\description{
Load word vectors data (\code{wordvec} or \code{embed}) from ".RData" file.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = demodata[1:200]
save(d, file="demo.RData")
d = load_wordvec("demo.RData")
d
d = load_embed("demo.RData")
d
unlink("demo.RData")  # delete file for code check

\dontrun{
# please first manually download the .RData file
# (see https://psychbruce.github.io/WordVector_RData.pdf)
# or transform plain text data by using `data_transform()`

# the RData file must be on your disk
# the following code cannot run unless you have the file
library(bruceR)
set.wd()
d = load_embed("../data-raw/GloVe/glove_wiki_50d.RData")
d
}

}
\seealso{
\code{\link{as_wordvec}} / \code{\link{as_embed}}

\code{\link{normalize}}

\code{\link{data_transform}}

\code{\link{data_wordvec_subset}}
}
