% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{significance_funnel}
\alias{significance_funnel}
\title{Make significance funnel plot}
\usage{
significance_funnel(yi, vi, xmin = min(yi), ymin = min(sqrt(vi)),
  xmax = max(yi), ymax = max(sqrt(vi)), plot.pooled = TRUE)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed. The signs of the estimates should be chosen
such that publication bias is assumed to operate in favor of positive estimates.}

\item{vi}{A vector of estimated variances for the point estimates}

\item{xmin}{x-axis (point estimate) lower limit for plot}

\item{ymin}{y-axis (standard error) lower limit for plot}

\item{xmax}{x-axis (point estimate) upper limit for plot}

\item{ymax}{y-axis (standard error) upper limit for plot}

\item{plot.pooled}{Should the fixed-effects pooled estimates within all studies and within only the nonaffirmative
studies be plotted as well?}
}
\description{
Creates a modified funnel plot that distinguishes between affirmative and nonaffirmative studies, helping detect the extent to which the nonaffirmative studies' point estimates are systematically smaller than
the entire set of point estimates. By default (\code{plot.pooled = TRUE}), also plots the fixed-effects pooled point
estimate within all studies (black diamond) and within only the nonaffirmative studies (blue diamond). The latter
represents a corrected fixed-effects estimate under worst-case publication bias.  When the diamonds are distant or if the
blue diamond represents a negligible effect size, then formal sensitivity analyses (via \code{PublicationBias::svalue})
may indicate that the meta-analysis is not robust.
}
\examples{

# compute meta-analytic effect sizes
require(metafor)
dat = metafor::escalc(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)

# flip signs since we think publication bias operates in favor of negative effects
dat$yi = -dat$yi

significance_funnel( yi = dat$yi,
                      vi = dat$vi,
                      plot.pooled = TRUE )
}
\references{
1. Mathur MB & VanderWeele TJ (2019). Sensitivity analysis for publication bias in meta-analyses. Preprint available at XXX.
}
