% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fsQCApermTest.R
\name{fsQCApermTest}
\alias{fsQCApermTest}
\title{A Simple Permutation Test for Type I Error in fsQCA}
\usage{
fsQCApermTest(y, configs, total.configs, num.iter = 10000, my.seed = 123,
  adj.method = "holm")
}
\arguments{
\item{y}{The outcome variable of interest.}

\item{configs}{A list of configurations to be tested against \code{y}.}

\item{total.configs}{The total number of configurations used in the original
fsQCA analysis. This will generally equal the number of lines in the
truth table used for Boolean minimization.}

\item{num.iter}{The number of iterations to use for the permutation test.
Larger numbers of iterations result in more precise p-values.}

\item{my.seed}{The seed used to generate random numbers.}

\item{adj.method}{The method used to calculate adjusted p-values (see
\code{\link{p.adjust}} for details).}
}
\value{
An object containing the aggregate results of the permutation test
as well as the individual permutations.
}
\description{
A permutation test for fuzzy-set qualitative comparative analysis (fsQCA),
designed to calculate the probability of a false positive given the number of
hypotheses implicitly tested and the distribution of the data.
}
\examples{
data(social.revolutions)
attach(social.revolutions)

intersect <- pmin(breakdown, pop.ins)
intersect2 <- pmin(breakdown, (1-pop.ins))
intersect3 <- pmin((1-breakdown), pop.ins)
intersect4 <- pmin((1-breakdown), (1-pop.ins))

test <- fsQCApermTest(y=soc.rev, configs=list(BI=intersect, Bi=intersect2,
   bI=intersect3, bi=intersect4), total.configs=4)
summary(test)
plot(test)
}
\keyword{adjust}
\keyword{fsQCA}
\keyword{inference}
\keyword{multiple}
\keyword{p-value}
\keyword{permutation}

