% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Confidence_Interval_Beta_Distribution.R
\name{bias.all}
\alias{bias.all}
\title{Calculate bias correction for confidence intervals from \code{\link{beta.meths.CI}}.}
\usage{
bias.all(p.mat, prey.mat, cal.mat = rep(1, length(ext.fa)),
  fat.cont = rep(1, nrow(prey.mat)), R.bias, noise, nprey, specify.noise,
  dist.meas, ext.fa)
}
\arguments{
\item{p.mat}{matrix containing the fatty acid signatures of the predators.}

\item{prey.mat}{matrix containing a representative fatty acid signature}

\item{cal.mat}{matrix of calibration factors where the \emph{i} th
column is to be used with the \emph{i} th predator. If modelling is
to be done without calibration coefficients, simply pass a
vector or matrix of ones.}

\item{fat.cont}{prey fat content}

\item{R.bias}{botstrap replicates}

\item{noise}{noise}

\item{nprey}{number of prey}

\item{specify.noise}{noise}

\item{dist.meas}{distance measure}

\item{ext.fa}{subset of FA's to use.}
}
\value{
Row 1 is Lambda CI, row 2 is Lambda skew, and row 3 is Beta CI
}
\description{
Calculate bias correction for confidence intervals from \code{\link{beta.meths.CI}}.
}
\examples{
## Fatty Acids
data(FAset)
fa.set = as.vector(unlist(FAset))
 
## Predators
data(predatorFAs)
tombstone.info = predatorFAs[,1:4]
predator.matrix = predatorFAs[, fa.set]
npredators = nrow(predator.matrix)

## Prey
prey.sub = preyFAs[, fa.set]
prey.sub = prey.sub / apply(prey.sub, 1, sum) 
group = as.vector(preyFAs$Species)
prey.matrix.full = cbind(group,prey.sub)
prey.matrix = MEANmeth(prey.matrix.full) 

## Calibration Coefficients
data(CC)
cal.vec = CC[CC$FA \%in\% fa.set, 2]
cal.mat = replicate(npredators, cal.vec)

# Note: uncomment examples to run. CRAN tests fail because execution time > 5 seconds
# diet.est <- p.QFASA(predator.mat = predator.matrix,
#                     prey.mat = prey.matrix,
#                     cal.mat = cal.mat,
#                     dist.meas = 2,
#                     start.val = rep(1,nrow(prey.matrix)),
#                     ext.fa = fa.set)[['Diet Estimates']]
# 
# bias <- bias.all(p.mat = diet.est,
#                  prey.mat = prey.matrix.full,
#                  cal.mat = cal.mat,
#                  R.bias = 10,
#                  noise = 0,
#                  nprey = 50,
#                  dist.meas = 2,
#                  ext.fa = fa.set)

}
