% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_CI_Code.R
\name{conf.meth}
\alias{conf.meth}
\title{Confidence Intervals for Diet Proportions}
\usage{
conf.meth(
  predator.mat,
  prey.mat,
  p.mat,
  cal.mat = rep(1, length(ext.fa)),
  dist.meas,
  FC = rep(1, nrow(prey.mat)),
  alpha = 0.05,
  nprey = 30,
  R.p = 1,
  R.ps = 100,
  R = 100,
  R.bias = 100,
  noise = 0,
  ext.fa
)
}
\arguments{
\item{predator.mat}{matrix containing fatty acid signatures of the predators
with fatty acids summing to one.}

\item{prey.mat}{prey database. A data frame with first column a
Species label and other columns fatty acid proportions summing to one..}

\item{p.mat}{matrix of previously computed predator diet estimates needed for
confidence interval calculation.}

\item{cal.mat}{matrix or vector of calibration coefficients of
predators. Each COLUMN corresponds to a different predator. Default is a
vector of ones. The number of fatty acids should be the same as the number
of predator and prey fatty acids.}

\item{dist.meas}{distance measure to use for estimation: 1=KL,
2=AIT or 3=CS}

\item{FC}{vector of prey fat content, one for each individual in prey database.
Note that this vector is
passed to the \code{\link{gen.pseudo.seals}} which expects fat
content values for individual prey samples while
\code{\link{pseudo.seal}} and  \code{\link{p.QFASA}}
expect a species average.  Default is a vector of ones.}

\item{alpha}{1-alpha is the family-wise or overall confidence level.
Default is 0.05 for an overall confidence level of 0.95.}

\item{nprey}{number of prey to sample from the prey database
when generating pseudo predators for the nuisance parameter
estimation using original QFASA simulating code. Default is 30.}

\item{R.p}{number of times to re-sample data.  Due to algorithm being slow,
the default parameter is 1.}

\item{R.ps}{number of pseudo predators to generate when estimating
nuisance parameters.  Default is 100.}

\item{R}{number of bootstrap replicates to use when generating
p-values for confidence interval estimation.  Default is 100.}

\item{R.bias}{number of replicates for bias computation.  Default is 100.}

\item{noise}{proportion of noise to include in the generation of pseudo predators
using original QFASA simulating code.}

\item{ext.fa}{subset of fatty acids to be used.  These should be the same as
those in predator.mat, prey.mat and cal.mat.}
}
\value{
Simultaneous (1-alpha)*100% confidence intervals based on the
   zero-inflated beta distribution.
}
\description{
Returns simultaneous confidence intervals for the diet of each species in the
prey database.
}
\details{
Intervals are biased corrected as recommended in Stewart, C. (2013).
   Intervals are slow to obtain, particularly if there are many prey types.
   See vignette on parallel execution to speed up calculations.
}
\examples{
## Reducing prey database to three species so that code below will run more quickly.
## Please uncomment code to run.

#set.seed(1234)
## Fatty Acids
#data(FAset)
#fa.set = as.vector(unlist(FAset))

## Sample of Predators
#data(predatorFAs)
#predator.matrix = predatorFAs[, -c(1:4)]
#predator.matrix.ext = predatorFAs[,fa.set]
#predator.matrix.ext = predator.matrix.ext/rowSums(predator.matrix.ext)

# Prey Database
#prey.red =
#preyFAs[preyFAs$Species=="capelin"|preyFAs$Species=="herring"|preyFAs$Species=="sandlance", ]
#prey.red = prey.red[,-c(1,3)]
#prey.red.ext = prey.red[,c("Species",fa.set)]
#prey.red.ext[,-1] <- prey.red.ext[,-1]/rowSums(prey.red.ext[,-1])
#prey.red.ext.means = MEANmeth(prey.red.ext)

## Calibration Coefficients

#data(CC)
#cal.vec = CC[CC$FA \%in\% fa.set, 2]

#diet.est <- p.QFASA(predator.mat = predator.matrix.ext,
#                    prey.mat = prey.red.ext.means,
#                    cal.mat = cal.vec,
#                   dist.meas = 2,
#                    start.val = rep(1,nrow(prey.red.ext.means)),
#                    ext.fa = fa.set)[['Diet Estimates']]

## conf.meth needs the full prey matrix unlike in p.QFASA
#ci <- conf.meth(predator.mat = predator.matrix.ext, prey.mat = prey.red.ext, cal.mat = cal.vec,
#          p.mat = diet.est, dist.meas = 2, ext.fa = fa.set)
}
\references{
Stewart, C. (2013) Zero-inflated beta distribution for
    modeling the proportions in quantitative fatty acid signature
    analysis. Journal of Applied Statistics, 40(5), 985-992.
}
