% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qwalk.r
\name{qwdap.qwalk}
\alias{qwdap.qwalk}
\title{Quantum Walk}
\usage{
qwdap.qwalk(edges, startindex, lens, scals, getfloat)
}
\arguments{
\item{edges}{your N*N adjacency matrix saved as list.}

\item{startindex}{the initial position of the quantum walker.}

\item{lens}{the number of records required in a round of sampling by a scaling factor.
Set the length of the series according to requirements.}

\item{scals}{the scaling factors used.}

\item{getfloat}{Whether to return floating point data.}
}
\value{
a object of class 'CTQW', the quantum walk results and some parameters.
}
\description{
Generate the modes, the probabilities that the walker being found at vertices.
An adjacency matrix is need for the process.
}
\details{
'qwdap.qwalk()' is used to generated modes for time series analysis, the result is a object
of class 'CTQW', the modes are saved in the object as a 3-dim array, and the parameters are also
store in the object.
The continuous time quantum walk is a continuous process, the modes are generated with a series
of times, the parameter 'scals' can be understood as the tolerance of the arithmetic time series.
Multiply tolerances can be passed in to obtain modes on different time scales through parameter
'scals'.
The probability of the series with the probabilities that the walker being found at the vertices, 
and the length depends on parameter 'lens'.
The data generated by this function is not recorded from the initial state. 
The shortest distance between all vertices and the initial position of the quantum walker is
obtained by the Dijkstra algorithm.The probabilities corresponding to each vertex are
recorded starting from the vertex furthest in the shortest distance is not 0.
The function is single thread.
}
\examples{
edges <- matrix(c(0,1,0,0,0,0,0,
                  1,0,1,0,0,0,0,
                  0,1,0,1,0,0,0,
                  0,0,1,0,1,0,0,
                  0,0,0,1,0,1,0,
                  0,0,0,0,1,0,1,
                  0,0,0,0,0,1,0),
                nrow = 7)
res.qwalk <- qwdap.qwalk(edges,1,100,scals=seq(from=0.01, by=0.01, length.out=5))

}
\author{
Pan Binghuang
}
