% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0gam_ext.R
\name{gam2beta}
\alias{gam2beta}
\title{Extract Functional Coefficient from \link[mgcv]{gam} Return}
\usage{
gam2beta(object, ...)
}
\arguments{
\item{object}{a \link[mgcv]{gam} object}

\item{...}{additional parameters of \link[mgcv]{plot.gam}, most importantly \code{n}}
}
\value{
\link{gam2beta} returns a \link[base]{numeric} \link[base]{vector}.
}
\description{
Extract the function coefficient from \link[mgcv]{gam} return
}
\details{
Extract beta function from \link[mgcv]{gam} return, using \link[mgcv]{plot.gam}.
}
\note{
Suppress the figure from printing; inspired by \code{oddsratio::no_plot}
}
\examples{
library(mgcv)
# ?mgcv::gam examples
set.seed(0)
f1 = function(x) {exp(2 * x)}
f2 = function(x) 0.2*x^11*(10*(1-x))^6+10*(10*x)^3*(1-x)^10 
f3 = function(x) {x*0}
n = 200
sig2 = 4
x0 = rep(1:4,50)
x1 = runif(n, 0, 1)
x2 = runif(n, 0, 1)
x3 = runif(n, 0, 1)
e = rnorm(n, 0, sqrt(sig2))
y = 2*x0 + f1(x1) + f2(x2) + f3(x3) + e
x0 = factor(x0)
b = gam(y~x0+s(x1)+s(x2)+s(x3))
plot(b)
gam2beta(b, n = 100)

}
