% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0coef_dichotom.R
\name{m_rpartD}
\alias{m_rpartD}
\title{Dichotomize Multiple Predictors via Recursive Partitioning}
\usage{
m_rpartD(y, X, ...)
}
\arguments{
\item{y}{a \link[survival]{Surv} object,
a \link[base]{logical} \link[base]{vector},
or \link[base]{numeric} \link[base]{vector}, the endpoint}

\item{X}{\link[base]{numeric} \link[base]{matrix},
columns being the predictors to be dichotomized}

\item{...}{additional parameters of \link{rpartD}, currently not in use}
}
\value{
\link{m_rpartD} returns a \link[base]{logical} \link[base]{matrix} of
the same dimension and dimension names as the argument \code{X},
with \link[base]{attributes}
\describe{
\item{\code{attr(,'branch')}}{\link[base]{list} of \link[base]{language} objects
(i.e., return of \link{rpartD}),
dichotomozing branches for each predictor}
}
}
\description{
To dichotomize multiple \link[base]{numeric} predictors
via recursive partitioning \link[rpart]{rpart}.
}
\details{
For each column of \code{X},

\itemize{

\item Find the dichotomizing branch of the endpoint \code{y} using the predictor \code{X[,i]},
via \link{rpartD}

\item Dichotomize \code{X[,i]} using this branch

}
}
\examples{
y = rnorm(30)
X = array(rnorm(30*4), dim = c(30, 4), dimnames = list(NULL, letters[1:4]))
m_rpartD(y, X)

}
