% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kb.test.R
\name{kb.test}
\alias{kb.test}
\alias{kb.test,ANY-method}
\alias{show,kb.test-method}
\title{Kernel-based quadratic distance Goodness-of-Fit tests}
\usage{
kb.test(
  x,
  y = NULL,
  h = NULL,
  method = "subsampling",
  B = 150,
  b = NULL,
  Quantile = 0.95,
  mu_hat = NULL,
  Sigma_hat = NULL,
  centeringType = "Nonparam",
  K_threshold = 10,
  alternative = "skewness"
)

\S4method{kb.test}{ANY}(
  x,
  y = NULL,
  h = NULL,
  method = "subsampling",
  B = 150,
  b = 0.9,
  Quantile = 0.95,
  mu_hat = NULL,
  Sigma_hat = NULL,
  centeringType = "Nonparam",
  K_threshold = 10,
  alternative = "skewness"
)

\S4method{show}{kb.test}(object)
}
\arguments{
\item{x}{Numeric matrix or vector of data values.}

\item{y}{Numeric matrix or vector of data values. Depending on the input
\code{y}, the corresponding test is performed.
\itemize{
\item if \code{y} = NULL, the function performs the tests for normality o
n \code{x}
\item if \code{y} is a data matrix, with same dimensions of \code{x}, the
function performs the two-sample test between \code{x} and \code{y}.
\item if \code{y} if a numeric or factor vector, indicating the group
memberships for each observation, the function performs the k-sample
test.
}}

\item{h}{Bandwidth for the kernel function. If a value is not provided, the
algorithm for the selection of an optimal h is performed
automatically. See the function \code{\link{select_h}} for more
details.}

\item{method}{The method used for critical value estimation ("subsampling",
"bootstrap", or "permutation")(default: "subsampling").}

\item{B}{The number of iterations to use for critical value estimation
(default: 150).}

\item{b}{The size of the subsamples used in the subsampling algorithm
(default: 0.8).}

\item{Quantile}{The quantile to use for critical value estimation, 0.95 is
the default value.}

\item{mu_hat}{Mean vector for the reference distribution.}

\item{Sigma_hat}{Covariance matrix of the reference distribution.}

\item{centeringType}{String indicating the method used for centering the
normal kernel ('Param' or 'Nonparam').}

\item{K_threshold}{maximum number of groups allowed. Default is 10. It is a
control parameter. Change in case of more than 10 samples.}

\item{alternative}{Family of alternative chosen for selecting h, between
"location", "scale" and "skewness" (only if \code{h}
is not provided).}

\item{object}{Object of class \code{kb.test}}
}
\value{
An S4 object of class \code{kb.test} containing the results of the
kernel-based quadratic distance tests, based on the normal kernel. The object
contains the following slots:
\itemize{
\item \code{method}: String indicating the normal kernel-based quadratic
distance test performed.
\item \code{x} Data list of samples X (and Y).
\item \code{Un} The value of the U-statistics.
\item \code{H0_Un} A logical value indicating whether or not the null
hypothesis is rejected according to Un.
\item \code{CV_Un} The critical value computed for the test Un.
\item \code{Vn} The value of the V-statistic (if available).
\item \code{H0_Vn} A logical value indicating whether or not the null
hypothesis is rejected according to Vn (if available).
\item \code{CV_Vn} The critical value computed for the test Vn
(if available).
\item \code{h} List with the value of bandwidth parameter used for the
normal kernel function. If \code{select_h} is used, the matrix of computed
power values and the corresponding power plot are also provided.
\item \code{B} Number of bootstrap/permutation/subsampling replications.
\item \code{var_Un} exact variance of the kernel-based U-statistic.
\item \code{cv_method} The method used to estimate the critical value
(one of "subsampling", "permutation" or "bootstrap").

}
}
\description{
This function performs the kernel-based quadratic distance goodness-of-fit
tests using the Gaussian kernel with tuning parameter h.
}
\details{
The function \code{kb.test} performs the kernel-based quadratic
distance tests using the Gaussian kernel with bandwidth parameter \code{h}.
Depending on the shape of the input \code{y} the function performs the tests
of multivariate normality, the non-parametric two-sample tests or the
k-sample tests.
}
\examples{
# create a kb.test object
x <- matrix(rnorm(100),ncol=2)
y <- matrix(rnorm(100),ncol=2)
# Normality test
my_test <- kb.test(x, h=0.5)
my_test
# Two-sample test
my_test <- kb.test(x,y,h=0.5, method="subsampling",b=0.9,
                     centeringType = "Nonparam")
my_test
# k-sample test
z <- matrix(rnorm(100,2),ncol=2)
dat <- rbind(x,y,z)
group <- rep(c(1,2,3),each=50)
my_test <- kb.test(x=dat,y=group,h=0.5, method="subsampling",b=0.9)
my_test

}
\references{
Markatou, M., Saraceno, G., Chen Y (2023). “Two- and k-Sample Tests Based on
Quadratic Distances.” Manuscript, (Department of Biostatistics, University at
Buffalo)

Lindsay, B.G., Markatou, M. & Ray, S. (2014) "Kernels, Degrees of Freedom,
and Power Properties of Quadratic Distance Goodness-of-Fit Tests", Journal
of the American Statistical Association, 109:505, 395-410,
DOI: 10.1080/01621459.2013.836972
}
