% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetDistance.R, R/tqDist.r
\name{SharedQuartetStatus}
\alias{SharedQuartetStatus}
\alias{QuartetStatus}
\title{Status of quartets}
\usage{
SharedQuartetStatus(trees, cf = trees[[1]])

QuartetStatus(trees, cf = trees[[1]])
}
\arguments{
\item{trees}{A list of trees of class \code{\link[ape:read.tree]{phylo}},
with identically labelled tips.}

\item{cf}{Comparison tree of class \code{\link[ape:read.tree]{phylo}}.  If unspecified,
each tree is compared to the first tree in \code{trees}.}
}
\value{
Returns a two dimensional array. Rows correspond to the input trees; the first row will report a perfect match if the first tree is specified as the comparison tree (or if \code{cf} is not specified).  Columns list the status of each quartet:
\describe{
\item{N}{The total number of quartet \emph{statements} for two trees of \emph{n} tips,
i.e. 2 \emph{Q}.}
\item{Q}{The total number of quartets for \emph{n} tips.}
\item{s}{The number of quartets that are resolved identically in both trees.}
\item{d}{The number of quartets that are resolved differently in each tree.}
\item{r1}{The number of quartets that are resolved in tree 1, but not in tree 2.}
\item{r2}{The number of quartets that are resolved in tree 2, but not in tree 1.}
\item{u}{The number of quartets that are unresolved in both trees.}
}
}
\description{
Determines the number of quartets that are consistent within pairs of
cladograms.
}
\details{
Given a list of trees, returns the number of quartet statements present in the
reference tree (the first entry in \code{trees}, if \code{cf} is not specified)
that are also present in each other tree.  A random pair of fully resolved
trees is expected to share \code{choose(n_tip, 4) / 3} quartets.

If trees do not bear the same number of tips, \code{SharedQuartetStatus} will
consider only the quartets that include taxa common to both trees.

From this information it is possible to calculate how many of all possible
quartets occur in one tree or the other, though there is not yet a function
calculating this; \href{https://github.com/ms609/Quartet/issues/new}{let us know}
if you would appreciate this functionality.

The status of each quartet is calculated using the algorithms of
Brodal \emph{et al}. (2013) and Holt \emph{et al}. (2014), implemented in the
tqdist C library (Sand \emph{et al}. 2014).
}
\section{Functions}{
\itemize{
\item \code{SharedQuartetStatus}: Reports split statistics obtained after removing all
tips that do not occur in both trees being compared.
}}

\examples{
 data('sq_trees')
 # Calculate the status of each quartet
 sq_status <- QuartetStatus(sq_trees)

 # Calculate Estabrook et al's similarity measures:
 SimilarityMetrics(sq_status)

}
\references{
{
\insertRef{Brodal2013}{Quartet}

\insertRef{Estabrook1985}{Quartet}

\insertRef{Holt2014}{Quartet}

\insertRef{Sand2014}{Quartet}
}
}
\seealso{
\code{\link{SplitStatus}}: Uses bipartition splits (groups/clades defined by
nodes or edges of the tree) instead of quartets as the unit of comparison.

Other element-by-element comparisons: \code{\link{CompareQuartets}},
  \code{\link{CompareSplits}},
  \code{\link{PairSharedQuartetStatus}},
  \code{\link{QuartetState}}, \code{\link{SplitStatus}}
}
\author{
Martin R. Smith
}
\concept{element-by-element comparisons}
