// Generated by rstantools.  Do not edit by hand.

/*
    R2D2ordinal is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    R2D2ordinal is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with R2D2ordinal.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_r2d2ord_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 62> locations_array__ =
  {" (found before start of program)",
  " (in 'r2d2ord', line 37, column 2 to column 19)",
  " (in 'r2d2ord', line 38, column 2 to column 17)",
  " (in 'r2d2ord', line 39, column 2 to column 18)",
  " (in 'r2d2ord', line 40, column 2 to column 19)",
  " (in 'r2d2ord', line 41, column 2 to column 17)",
  " (in 'r2d2ord', line 44, column 2 to column 47)",
  " (in 'r2d2ord', line 45, column 16 to column 52)",
  " (in 'r2d2ord', line 45, column 15 to column 53)",
  " (in 'r2d2ord', line 45, column 2 to column 53)",
  " (in 'r2d2ord', line 46, column 2 to column 35)",
  " (in 'r2d2ord', line 51, column 4 to column 68)",
  " (in 'r2d2ord', line 52, column 4 to column 34)",
  " (in 'r2d2ord', line 50, column 7 to line 53, column 3)",
  " (in 'r2d2ord', line 48, column 4 to column 61)",
  " (in 'r2d2ord', line 49, column 4 to column 35)",
  " (in 'r2d2ord', line 47, column 21 to line 50, column 3)",
  " (in 'r2d2ord', line 47, column 2 to line 53, column 3)",
  " (in 'r2d2ord', line 55, column 11 to column 12)",
  " (in 'r2d2ord', line 55, column 4 to column 20)",
  " (in 'r2d2ord', line 56, column 4 to column 27)",
  " (in 'r2d2ord', line 57, column 4 to column 33)",
  " (in 'r2d2ord', line 59, column 6 to column 57)",
  " (in 'r2d2ord', line 58, column 4 to line 59, column 57)",
  " (in 'r2d2ord', line 60, column 4 to column 37)",
  " (in 'r2d2ord', line 61, column 4 to column 30)",
  " (in 'r2d2ord', line 54, column 17 to line 62, column 3)",
  " (in 'r2d2ord', line 54, column 2 to line 62, column 3)",
  " (in 'r2d2ord', line 29, column 2 to column 17)",
  " (in 'r2d2ord', line 30, column 2 to column 17)",
  " (in 'r2d2ord', line 31, column 2 to column 17)",
  " (in 'r2d2ord', line 32, column 18 to column 19)",
  " (in 'r2d2ord', line 32, column 13 to column 14)",
  " (in 'r2d2ord', line 32, column 2 to column 21)",
  " (in 'r2d2ord', line 33, column 25 to column 26)",
  " (in 'r2d2ord', line 33, column 2 to column 28)",
  " (in 'r2d2ord', line 34, column 2 to column 22)",
  " (in 'r2d2ord', line 37, column 10 to column 13)",
  " (in 'r2d2ord', line 38, column 9 to column 10)",
  " (in 'r2d2ord', line 41, column 10 to column 11)",
  " (in 'r2d2ord', line 4, column 4 to column 34)",
  " (in 'r2d2ord', line 5, column 11 to column 12)",
  " (in 'r2d2ord', line 5, column 4 to column 17)",
  " (in 'r2d2ord', line 6, column 11 to column 12)",
  " (in 'r2d2ord', line 6, column 14 to column 15)",
  " (in 'r2d2ord', line 6, column 4 to column 41)",
  " (in 'r2d2ord', line 8, column 4 to column 45)",
  " (in 'r2d2ord', line 10, column 6 to column 84)",
  " (in 'r2d2ord', line 9, column 4 to line 10, column 84)",
  " (in 'r2d2ord', line 11, column 4 to column 51)",
  " (in 'r2d2ord', line 13, column 19 to column 31)",
  " (in 'r2d2ord', line 13, column 4 to column 31)",
  " (in 'r2d2ord', line 16, column 6 to column 58)",
  " (in 'r2d2ord', line 17, column 6 to column 22)",
  " (in 'r2d2ord', line 18, column 6 to column 24)",
  " (in 'r2d2ord', line 15, column 19 to line 19, column 5)",
  " (in 'r2d2ord', line 15, column 4 to line 19, column 5)",
  " (in 'r2d2ord', line 20, column 4 to column 61)",
  " (in 'r2d2ord', line 3, column 64 to line 21, column 3)",
  " (in 'r2d2ord', line 24, column 4 to column 92)",
  " (in 'r2d2ord', line 25, column 4 to column 16)",
  " (in 'r2d2ord', line 23, column 51 to line 26, column 3)"};
template <bool propto__, typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T0__>, T1__, stan::base_type_t<T2__>>
induced_dirichlet_lpdf(const T0__& tau_arg__, const T1__& W, const T2__&
                       alpha_arg__, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__>
inv_gauss_lpdf(const T0__& x, const T1__& mu, const T2__& lambda,
               std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
stan::promote_args_t<stan::base_type_t<T0__>, T1__, stan::base_type_t<T2__>>
induced_dirichlet_lpdf(const T0__& tau_arg__, const T1__& W, const T2__&
                       alpha_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__, stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& tau = stan::math::to_ref(tau_arg__);
  const auto& alpha = stan::math::to_ref(alpha_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int K = std::numeric_limits<int>::min();
    current_statement__ = 40;
    K = (stan::math::num_elements(tau) + 1);
    current_statement__ = 41;
    stan::math::validate_non_negative_index("PI", "K", K);
    Eigen::Matrix<local_scalar_t__,-1,1> PI =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
    current_statement__ = 43;
    stan::math::validate_non_negative_index("J", "K", K);
    current_statement__ = 44;
    stan::math::validate_non_negative_index("J", "K", K);
    Eigen::Matrix<local_scalar_t__,-1,-1> J =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
    current_statement__ = 45;
    stan::model::assign(J, stan::math::rep_matrix(0, K, K),
      "assigning variable J");
    current_statement__ = 46;
    stan::model::assign(PI,
      stan::math::normal_cdf(
        stan::model::rvalue(tau, "tau", stan::model::index_uni(1)), 0,
        stan::math::sqrt((1 + W))), "assigning variable PI",
      stan::model::index_uni(1));
    current_statement__ = 48;
    for (int k = 2; k <= (K - 1); ++k) {
      current_statement__ = 47;
      stan::model::assign(PI,
        (stan::math::normal_cdf(
           stan::model::rvalue(tau, "tau", stan::model::index_uni(k)), 0,
           stan::math::sqrt((1 + W))) -
        stan::math::normal_cdf(
          stan::model::rvalue(tau, "tau", stan::model::index_uni((k - 1))),
          0, stan::math::sqrt((1 + W)))), "assigning variable PI",
        stan::model::index_uni(k));
    }
    current_statement__ = 49;
    stan::model::assign(PI, (1 -
      stan::math::normal_cdf(
        stan::model::rvalue(tau, "tau", stan::model::index_uni((K - 1))), 0,
        stan::math::sqrt((1 + W)))), "assigning variable PI",
      stan::model::index_uni(K));
    current_statement__ = 51;
    for (int k = 1; k <= K; ++k) {
      current_statement__ = 50;
      stan::model::assign(J, 1, "assigning variable J",
        stan::model::index_uni(k), stan::model::index_uni(1));
    }
    current_statement__ = 56;
    for (int k = 2; k <= K; ++k) {
      local_scalar_t__ rho = DUMMY_VAR__;
      current_statement__ = 52;
      rho = stan::math::exp(
              stan::math::normal_lpdf<false>(
                stan::model::rvalue(tau, "tau",
                  stan::model::index_uni((k - 1))), 0,
                stan::math::sqrt((1 + W))));
      current_statement__ = 53;
      stan::model::assign(J, -rho, "assigning variable J",
        stan::model::index_uni(k), stan::model::index_uni(k));
      current_statement__ = 54;
      stan::model::assign(J, rho, "assigning variable J",
        stan::model::index_uni((k - 1)), stan::model::index_uni(k));
    }
    current_statement__ = 57;
    return (stan::math::dirichlet_lpdf<false>(PI, alpha) +
           stan::math::log_determinant(J));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
stan::promote_args_t<T0__, T1__, T2__>
inv_gauss_lpdf(const T0__& x, const T1__& mu, const T2__& lambda,
               std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  int current_statement__ = 0;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ lpdf = DUMMY_VAR__;
    current_statement__ = 59;
    lpdf = ((((0.5 * stan::math::log(lambda)) - (0.5 *
      stan::math::log((2 * stan::math::pi())))) - (1.5 * stan::math::log(x)))
      - ((lambda * stan::math::pow((x - mu), 2)) / ((2 *
      stan::math::pow(mu, 2)) * x)));
    current_statement__ = 60;
    return lpdf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_r2d2ord final : public model_base_crtp<model_r2d2ord> {
private:
  int K;
  int N;
  int p;
  std::vector<Eigen::Matrix<double,1,-1>> X;
  std::vector<int> Y;
  Eigen::Matrix<double,1,-1> hyper_data__;
  int tau_1dim__;
  Eigen::Map<Eigen::Matrix<double,1,-1>> hyper{nullptr, 0};
public:
  ~model_r2d2ord() {}
  model_r2d2ord(stan::io::var_context& context__, unsigned int
                random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_r2d2ord_namespace::model_r2d2ord";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 28;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 28;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 28;
      stan::math::check_greater_or_equal(function__, "K", K, 2);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 29;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 29;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 30;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 30;
      stan::math::check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 31;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 32;
      stan::math::validate_non_negative_index("X", "p", p);
      current_statement__ = 33;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(p)});
      X = std::vector<Eigen::Matrix<double,1,-1>>(N,
            Eigen::Matrix<double,1,-1>::Constant(p,
              std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 33;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 33;
        pos__ = 1;
        current_statement__ = 33;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 33;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 33;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 33;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 34;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "Y", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      Y = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 35;
      Y = context__.vals_i("Y");
      current_statement__ = 35;
      stan::math::check_greater_or_equal(function__, "Y", Y, 1);
      current_statement__ = 35;
      stan::math::check_less_or_equal(function__, "Y", Y, K);
      current_statement__ = 36;
      context__.validate_dims("data initialization", "hyper", "double",
        std::vector<size_t>{static_cast<size_t>(3)});
      hyper_data__ = Eigen::Matrix<double,1,-1>::Constant(3,
                       std::numeric_limits<double>::quiet_NaN());
      new (&hyper)
        Eigen::Map<Eigen::Matrix<double,1,-1>>(hyper_data__.data(), 3);
      {
        std::vector<local_scalar_t__> hyper_flat__;
        current_statement__ = 36;
        hyper_flat__ = context__.vals_r("hyper");
        current_statement__ = 36;
        pos__ = 1;
        current_statement__ = 36;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 36;
          stan::model::assign(hyper, hyper_flat__[(pos__ - 1)],
            "assigning variable hyper", stan::model::index_uni(sym1__));
          current_statement__ = 36;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 37;
      tau_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 37;
      tau_1dim__ = (K - 1);
      current_statement__ = 37;
      stan::math::validate_non_negative_index("tau", "K - 1", tau_1dim__);
      current_statement__ = 38;
      stan::math::validate_non_negative_index("beta", "p", p);
      current_statement__ = 39;
      stan::math::validate_positive_index("phi", "p", p);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = tau_1dim__ + p + 1 + 1 + (p - 1);
  }
  inline std::string model_name() const final {
    return "model_r2d2ord";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_r2d2ord_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> tau =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(tau_1dim__,
          DUMMY_VAR__);
      current_statement__ = 1;
      tau = in__.template read_constrain_ordered<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__,
              tau_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      local_scalar_t__ W = DUMMY_VAR__;
      current_statement__ = 3;
      W = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
            lp__);
      local_scalar_t__ xi = DUMMY_VAR__;
      current_statement__ = 4;
      xi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
             lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> phi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 5;
      phi = in__.template read_constrain_simplex<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, p);
      {
        current_statement__ = 6;
        lp_accum__.add(induced_dirichlet_lpdf<propto__>(tau, W,
                         stan::math::rep_vector(2, K), pstream__));
        current_statement__ = 9;
        for (int j = 1; j <= p; ++j) {
          current_statement__ = 7;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(
                           stan::model::rvalue(beta, "beta",
                             stan::model::index_uni(j)), 0,
                           stan::math::sqrt(
                             (stan::model::rvalue(phi, "phi",
                                stan::model::index_uni(j)) * W))));
        }
        current_statement__ = 10;
        lp_accum__.add(stan::math::dirichlet_lpdf<propto__>(phi,
                         stan::math::rep_vector(1, p)));
        current_statement__ = 17;
        if (stan::math::logical_lt(
              stan::model::rvalue(hyper, "hyper", stan::model::index_uni(1)),
              -0.5)) {
          current_statement__ = 14;
          lp_accum__.add(inv_gauss_lpdf<propto__>(W,
                           stan::math::sqrt(
                             (stan::model::rvalue(hyper, "hyper",
                                stan::model::index_uni(3)) /
                             (stan::model::rvalue(hyper, "hyper",
                                stan::model::index_uni(2)) + (2 * xi)))),
                           stan::model::rvalue(hyper, "hyper",
                             stan::model::index_uni(3)), pstream__));
          current_statement__ = 15;
          lp_accum__.add(stan::math::gamma_lpdf<propto__>(xi,
                           -(stan::model::rvalue(hyper, "hyper",
                               stan::model::index_uni(1)) + 0.5), W));
        } else {
          current_statement__ = 11;
          lp_accum__.add(inv_gauss_lpdf<propto__>(W,
                           stan::math::sqrt(
                             ((stan::model::rvalue(hyper, "hyper",
                                 stan::model::index_uni(3)) + (2 * xi)) /
                             stan::model::rvalue(hyper, "hyper",
                               stan::model::index_uni(2)))),
                           (stan::model::rvalue(hyper, "hyper",
                              stan::model::index_uni(3)) + (2 * xi)),
                           pstream__));
          current_statement__ = 12;
          lp_accum__.add(stan::math::gamma_lpdf<propto__>(xi,
                           (stan::model::rvalue(hyper, "hyper",
                              stan::model::index_uni(1)) + 0.5), (1 / W)));
        }
        current_statement__ = 27;
        for (int n = 1; n <= N; ++n) {
          current_statement__ = 18;
          stan::math::validate_non_negative_index("theta", "K", K);
          Eigen::Matrix<local_scalar_t__,-1,1> theta =
            Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
          local_scalar_t__ gamma = DUMMY_VAR__;
          current_statement__ = 20;
          gamma = stan::math::multiply(
                    stan::model::rvalue(X, "X", stan::model::index_uni(n)),
                    beta);
          current_statement__ = 21;
          stan::model::assign(theta,
            stan::math::Phi(
              (stan::model::rvalue(tau, "tau", stan::model::index_uni(1)) -
              gamma)), "assigning variable theta", stan::model::index_uni(1));
          current_statement__ = 23;
          for (int k = 2; k <= (K - 1); ++k) {
            current_statement__ = 22;
            stan::model::assign(theta,
              (stan::math::Phi(
                 (stan::model::rvalue(tau, "tau", stan::model::index_uni(k))
                 - gamma)) -
              stan::math::Phi(
                (stan::model::rvalue(tau, "tau",
                   stan::model::index_uni((k - 1))) - gamma))),
              "assigning variable theta", stan::model::index_uni(k));
          }
          current_statement__ = 24;
          stan::model::assign(theta, (1 -
            stan::math::Phi(
              (stan::model::rvalue(tau, "tau",
                 stan::model::index_uni((K - 1))) - gamma))),
            "assigning variable theta", stan::model::index_uni(K));
          current_statement__ = 25;
          lp_accum__.add(stan::math::categorical_lpmf<propto__>(
                           stan::model::rvalue(Y, "Y",
                             stan::model::index_uni(n)), theta));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_r2d2ord_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> tau =
        Eigen::Matrix<double,-1,1>::Constant(tau_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      tau = in__.template read_constrain_ordered<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__,
              tau_1dim__);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      double W = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      W = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
            lp__);
      double xi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      xi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
             lp__);
      Eigen::Matrix<double,-1,1> phi =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      phi = in__.template read_constrain_simplex<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, p);
      out__.write(tau);
      out__.write(beta);
      out__.write(W);
      out__.write(xi);
      out__.write(phi);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> tau =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(tau_1dim__,
          DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(tau,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(tau_1dim__),
        "assigning variable tau");
      out__.write_free_ordered(tau);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable beta");
      out__.write(beta);
      local_scalar_t__ W = DUMMY_VAR__;
      current_statement__ = 3;
      W = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, W);
      local_scalar_t__ xi = DUMMY_VAR__;
      current_statement__ = 4;
      xi = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, xi);
      Eigen::Matrix<local_scalar_t__,-1,1> phi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(phi,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable phi");
      out__.write_free_simplex(phi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "tau", "double",
        std::vector<size_t>{static_cast<size_t>(tau_1dim__)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "W", "double",
        std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "xi", "double",
        std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "phi", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> tau =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(tau_1dim__,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> tau_flat__;
        current_statement__ = 1;
        tau_flat__ = context__.vals_r("tau");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(tau, tau_flat__[(pos__ - 1)],
            "assigning variable tau", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_ordered(tau);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
      local_scalar_t__ W = DUMMY_VAR__;
      current_statement__ = 3;
      W = context__.vals_r("W")[(1 - 1)];
      out__.write_free_lb(0, W);
      local_scalar_t__ xi = DUMMY_VAR__;
      current_statement__ = 4;
      xi = context__.vals_r("xi")[(1 - 1)];
      out__.write_free_lb(0, xi);
      Eigen::Matrix<local_scalar_t__,-1,1> phi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> phi_flat__;
        current_statement__ = 5;
        phi_flat__ = context__.vals_r("phi");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(phi, phi_flat__[(pos__ - 1)],
            "assigning variable phi", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(phi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"tau", "beta", "W", "xi", "phi"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    tau_1dim__)},
                std::vector<size_t>{static_cast<size_t>(p)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(p)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "tau" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "W");
    param_names__.emplace_back(std::string() + "xi");
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "phi" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "tau" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "W");
    param_names__.emplace_back(std::string() + "xi");
    for (int sym1__ = 1; sym1__ <= (p - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "phi" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(tau_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"W\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"xi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(tau_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"W\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"xi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((p -1)) + "},\"block\":\"parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((tau_1dim__ + p) + 1) + 1) + p);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((tau_1dim__ + p) + 1) + 1) + p);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_r2d2ord_namespace::model_r2d2ord;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_r2d2ord_namespace::profiles__;
}
#endif
#endif
