% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ws2foreign.R
\name{ws2foreign}
\alias{ws2foreign}
\title{Converts data from one format to another within MLwiN}
\usage{
ws2foreign(wsfile, foreignfile, MLwiNPath = NULL, x64 = NULL)
}
\arguments{
\item{wsfile}{A file name specifying the data file (with a specific
extension) to be converted.}

\item{foreignfile}{A file name specifying the data file (with a specific
extension) after conversion.}

\item{MLwiNPath}{A path to the MLwiN folder. By default, \code{MLwiNPath = NULL}
and path set by \code{options('MLwiN_path')}, the default for which can be
changed via \code{options(MLwiN_path = 'path/to/MLwiN vX.XX/')}).}

\item{x64}{A logical value indicating whether the 64 bit version of MLwiN is
used, the default for this is determined by the version of R used. If
\code{FALSE}, the 32 bit version is called.}
}
\description{
This function converts data from one format to another within MLwiN, via
MLwiN macro language. The \code{foreign} package allows R to read data files
for most of these formats.
}
\details{
MLwiN supports conversion between MLwiN (*.wsz, *.ws), Minitab (*.mtw), SAS
(*.xpt), SPSS (*.sav), and Stata (*.dta) files.

The converted data file (with a specific extension) will be saved to the file
specified by \code{foreignfile}.
}
\examples{
\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

## Modify the following path as appropriate:
wsfile = 'C:/Program Files (x86)/MLwiN v2.32/samples/tutorial.ws'
## the tutorial.dta file will be saved in the temporary folder
inputfile = paste(tempdir(), '/tutorial.dta', sep = '')
ws2foreign(wsfile, foreignfile = inputfile)
library(foreign)
indata = read.dta(inputfile)
str(indata)
}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link[foreign]{read.dta}}
}

