% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_vectorstore.R
\name{create_vectorstore}
\alias{create_vectorstore}
\title{create_vectorstore.R — Vector-store utilities}
\usage{
create_vectorstore(
  db_path = ":memory:",
  overwrite = FALSE,
  embedding_dim = 1536,
  load_vss = identical(Sys.getenv("_R_CHECK_PACKAGE_NAME_"), "")
)
}
\arguments{
\item{db_path}{Path to the DuckDB file (\"`:memory:`\" for RAM).}

\item{overwrite}{If `TRUE`, delete any existing file / table.}

\item{embedding_dim}{Dimension of the embeddings stored.}

\item{load_vss}{Try to load the experimental `vss` extension?
Defaults to `TRUE` except during CRAN checks where it is forced `FALSE`.}
}
\value{
A live `duckdb_connection`. Disconnect manually with
  `DBI::dbDisconnect(con, shutdown = TRUE)`.
}
\description{
Tools to
• embed text with the OpenAI API
• create a DuckDB-backed vector store (optionally with the `vss` extension)
• insert documents with embeddings (handles chunking)
• build HNSW/FTS indexes and run nearest-neighbour search
}
\details{
Only `create_vectorstore()` is exported; all other helpers are internal.
}
