% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.data.R
\name{example.data}
\alias{example.data}
\title{Species-specific anatomy input}
\usage{
example.data(species = "LOT_PICEA")
}
\arguments{
\item{species}{a character string specifying the species from which the example data should be loaded. Valid options include; \emph{Picea abies} = "LOT_PICEA", \emph{Larix siberica} = "SIB_LARIX", \emph{Pinus cembra} = "MOUNT_PINUS", \emph{Pinus sylvestris} = "LOW_PINUS".}
}
\value{
A \code{\link{data.frame}} containing anatomical measurements from the selected species.
}
\description{
This function provides a \code{\link{data.frame}} containing standard anatomical measurements from xylem cross-sections images analysed with ROXAS (version 3.0). From the dataset described in \code{\link{anatomy.data}}, multiple input examples can be provided, including; 1) Norway Spruce (\emph{Picea abies}) from the Loetschental, Switzerland, 2) Siberian larch (\emph{Larix siberica}) from Siberia, Russia, 3) Stone pine (\emph{Pinus cembra}) from the Dolomite mountains, Italy, and 4) Scots pine (\emph{Pinus sylvestris}) from the eastern lowlands, Germany.
}
\details{
This datasets can be applied as an example to test functions provided in the package. Other examples of ROXAS output can be obtained via: \href{http://www.wsl.ch//roxas/}{WSL - ROXAS}.
}
\examples{
#loading example data
input<-example.data(species="LOT_PICEA")
input
str(input)
}
