% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{methods}
\name{sqlCreateTable}
\alias{sqlCreateTable}
\alias{sqlCreateTable,AthenaConnection-method}
\title{Creates query to create a simple Athena table}
\usage{
\S4method{sqlCreateTable}{AthenaConnection}(con, table = NULL,
  fields = NULL, field.types = NULL, partition = NULL,
  s3.location = NULL, file.type = c("csv", "tsv", "parquet"), ...)
}
\arguments{
\item{con}{A database connection.}

\item{table}{Name of the table. Escaped with
\code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[=dbDataType]{dbDataType()}}.}

\item{field.types}{Additional field types used to override derived types.}

\item{partition}{Partition Athena table (needs to be a named list or vector) for example: \code{c(var1 = "2019-20-13")}}

\item{s3.location}{s3 bucket to store Athena table}

\item{file.type}{What file type to store data.frame on s3, RAthena currently supports ["csv", "tsv", "parquet"]}

\item{...}{Other arguments used by individual methods.}
}
\value{
\code{sqlCreateTable} returns data.frame's \code{DDL} in the \code{\link[DBI]{SQL}} format.
}
\description{
Creates an interface to compose \code{CREATE EXTERNAL TABLE}.
}
\examples{
\donttest{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())
                 
# Create DDL for iris data.frame
sqlCreateTable(con, "iris", iris, s3.location = "s3://path/to/athena/table")

# Create DDL for iris data.frame with partition
sqlCreateTable(con, "iris", iris, 
               partition = c("timestamp" = format(Sys.Date(), "\%Y\%m\%d")),
               s3.location = "s3://path/to/athena/table")
               
# Create DDL for iris data.frame with partition and file.type parquet
sqlCreateTable(con, "iris", iris, 
               partition = c("timestamp" = format(Sys.Date(), "\%Y\%m\%d")),
               s3.location = "s3://path/to/athena/table",
               file.type = "parquet")

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{sqlCreateTable}}
}
