% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{estimate_factor_group}
\alias{estimate_factor_group}
\title{Estimates group factors}
\usage{
estimate_factor_group(
  robust,
  Y,
  X,
  beta_est,
  g,
  lambda,
  comfactor,
  factor_group,
  S,
  k,
  kg,
  method_estimate_beta = "individual",
  method_estimate_factors = "macro",
  initialise = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with group membership for all individuals}

\item{lambda}{loadings of the estimated common factors}

\item{comfactor}{estimated common factors}

\item{factor_group}{estimated group specific factors}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{method_estimate_factors}{defines method of robust estimaton of the factors: "macro", "pertmm" or "cz"}

\item{initialise}{indicator of being in the initialisation phase}

\item{verbose}{when TRUE, it prints messages}
}
\value{
Return a list with an element for each estimated group. Each element of the list is a matrix with the group specific factors as rows.
}
\description{
Estimates group factors
}
