% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{generate_Y}
\alias{generate_Y}
\title{Generate panel data Y for simulations.}
\usage{
generate_Y(
  NN,
  TT,
  k_true,
  kg_true,
  g_true,
  beta_true,
  lambda_group_true,
  factor_group_true,
  lambda_true,
  comfactor_true,
  eps,
  X
)
}
\arguments{
\item{NN}{number of time series}

\item{TT}{length of time series}

\item{k_true}{true number of common factors}

\item{kg_true}{Vector of length the number of groups. Each element contains the true number of group factors for that group.}

\item{g_true}{vector of length NN with true group memberships}

\item{beta_true}{true coefficients of the observable variables}

\item{lambda_group_true}{loadings of the true group specific factors}

\item{factor_group_true}{true group specific factors}

\item{lambda_true}{loadings of the true common factors}

\item{comfactor_true}{true common factors}

\item{eps}{NN x TT-matrix containing the error term}

\item{X}{dataframe with the observed variables}
}
\value{
NN x TT matrix
}
\description{
Generate panel data Y for simulations.
}
