% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel-api.R
\name{kernel_api}
\alias{kernel_api}
\title{REDCapR internal function for calling the REDCap API}
\usage{
kernel_api(
  redcap_uri,
  post_body,
  config_options,
  encoding = "UTF-8",
  content_type = "text/csv",
  handle_httr = NULL,
  encode_httr = "form"
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{post_body}{List of contents expected by the REDCap API.  Required.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{encoding}{The encoding value passed to \code{\link[httr:content]{httr::content()}}.  Defaults
to 'UTF-8'.}

\item{content_type}{The MIME value passed to \code{\link[httr:content]{httr::content()}}.  Defaults
to 'text/csv'.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.}

\item{encode_httr}{The value passed to the \code{encode} parameter of
\code{\link[httr:POST]{httr::POST()}}.
Defaults to \code{"form"}, which is appropriate for most actions.
(Currently, the only exception is importing a file,
which uses "multipart".)}
}
\value{
A \link[utils:packageDescription]{utils::packageVersion}.
}
\description{
This function is used by other functions to read and write values.
}
\details{
If the API call is unsuccessful, a value of
\code{base::package_version("0.0.0")} will be returned.  This ensures that a
the function will always return an object of class \link[base:numeric_version]{base::package_version}.
It guarantees the value can always be used in \code{\link[utils:compareVersion]{utils::compareVersion()}}.
}
\examples{
config_options <- NULL
uri            <- "https://bbmc.ouhsc.edu/redcap/api/"
token          <- "9A81268476645C4E5F03428B8AC3AA7B"
post_body      <- list(
  token    = token,
  content  = "project",
  format   = "csv"
)
\dontrun{
kernel <- REDCapR:::kernel_api(uri, post_body, config_options)

# Consume the results in a few different ways.
kernel$result
read.csv(text = kernel$raw_text)
as.list(read.csv(text = kernel$raw_text))
}
}
